% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{curl_download}
\alias{curl_download}
\title{Download file to disk}
\usage{
curl_download(url, destfile, quiet = TRUE, mode = "wb",
  handle = new_handle())
}
\arguments{
\item{url}{A character string naming the URL of a resource to be downloaded.}

\item{destfile}{A character string with the name where the downloaded file
is saved. Tilde-expansion is performed.}

\item{quiet}{If \code{TRUE}, suppress status messages (if any), and the
progress bar.}

\item{mode}{A character string specifying the mode with which to write the file.
Useful values are \code{"w"}, \code{"wb"} (binary), \code{"a"} (append)
and \code{"ab"}.}

\item{handle}{a curl handle object}
}
\value{
Path of downloaded file (invisibly).
}
\description{
Libcurl implementation of \code{C_download} (the "internal" download method)
with added support for https, ftps, gzip, etc. Default behavior is identical
to \code{\link{download.file}}, but request can be fully configured by passing
a custom \code{\link{handle}}.
}
\details{
The main difference between \code{curl_download} and \code{curl_fetch_disk}
is that \code{curl_download} checks the http status code before starting the
download, and raises an error when status is non-successful. The behavior of
\code{curl_fetch_disk} on the other hand is to proceed as normal and write
the error page to disk in case of a non success response.
}
\examples{
# Download large file
\dontrun{
url <- "http://www2.census.gov/acs2011_5yr/pums/csv_pus.zip"
tmp <- tempfile()
curl_download(url, tmp)
}
}
