% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_class.R
\name{add_class}
\alias{add_class}
\alias{set_class}
\alias{add_comment}
\alias{set_comment}
\title{Add to object helpers}
\usage{
add_class(x, new)

set_class(x, new)

add_comment(x, new)

set_comment(x, new)
}
\arguments{
\item{x}{object to alter}

\item{new}{new characteristic}
}
\description{
These function make using pipe functions easier when altering
an object.
}
\section{Functions}{
\itemize{
\item \code{set_class}: Overwrite the class

\item \code{add_comment}: Add a comment

\item \code{set_comment}: Overwrite the comment
}}

\examples{
# set versions will replace anything already there.
a <- set_class(TRUE, 'example')
a <- set_comment(a, 'this is an example of setting a comment')

# Add version will add to `c()` anything there.
b <- add_class(a, 'ex123')
b <- add_comment(b, 'but you can also add more information')

class(a)
class(b)

comment(a)
comment(b)

}
