#' Murray-Darling Basin Rainfall Data
#' 
#' A dataset containing rainfall recordings from 78 gauging stations from the 
#' Murray-Darling Basin in Southeastern Australia.
#' 
#' \itemize{
#'   \item X020020. station No.020020
#'   \item X024501. station No.024501 
#'   \item ...
#'   \item date.month month information
#' }
#' 
#' @docType data
#' @keywords datasets
#' @format A data frame with 1200 rows and 79 variables
#' @name hqmr.data
NULL


#' Complete Chunk Data
#' A chunk of data with no missing values from the Murray-Darling Basin Rainfall Data
#' 
#' \itemize{
#'   \item X020020. station No.020020
#'   \item X024501. station No.024501 
#'   \item ...
#' }
#' 
#' @docType data
#' @keywords datasets
#' @format A data frame with 576 rows and 78 variables
#' @name complete.chunk
NULL


#' Date month data
#' Date information for the Murray-Darling Basin rainfall data
#' 
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of dates which length is 1200. 
#' @name date.month
NULL

