% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{roc}
\alias{roc}
\title{Calculate a ROC curve}
\source{
Forked from the \pkg{ROCR} package
}
\usage{
roc(data, x, class, pos_class, neg_class, direction = ">=",
  silent = FALSE)
}
\arguments{
\item{data}{A data.frame or matrix. Will be converted to a data.frame.}

\item{x}{(character) The numeric independent (predictor) variable.}

\item{class}{(character) A binary vector of outcome values.}

\item{pos_class}{The value of 'class' that represents the positive cases.}

\item{neg_class}{The value of 'class' that represents the negative cases.}

\item{direction}{(character) One of ">=" or "<=". Specifies if the positive
class is associated with higher values of x (default).}

\item{silent}{If FALSE and the ROC curve contains no positives or negatives,
a warning is generated.}
}
\value{
A data frame with the columns x.sorted, tp, fp, tn, fn, tpr, tnr, fpr,
and fnr.
}
\description{
Given a \code{data.frame} with a numeric predictor variable and a binary outcome
variable this function returns a \code{data.frame} that includes all elements of
the confusion matrix (true positives, false positives, true negatives,
and false negatives) for every unique value of the predictor variable.
Additionally, the true positive rate (tpr), false positive rate (fpr),
true negative rate (tnr) and false negative rate (fnr) are returned.
}
\details{
To enable classifying all observations as belonging to only one class the
predictor values will be augmented by Inf or -Inf. The returned object can
be plotted with plot_roc.
}
\examples{
## First two classes of the iris data
dat <- iris[1:100, ]
roc_curve <- roc(data = dat, x = "Petal.Width", class = "Species",
pos_class = "versicolor", neg_class = "setosa", direction = ">=")
roc_curve
plot_roc(roc_curve)
}
\seealso{
Other main cutpointr functions: \code{\link{add_metric}},
  \code{\link{cutpointr_}}, \code{\link{cutpointr}},
  \code{\link{multi_cutpointr}},
  \code{\link{predict.cutpointr}}
}
\concept{main cutpointr functions}
