% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholdingFunctions.R
\name{adaptiveLassoThreshold}
\alias{adaptiveLassoThreshold}
\title{Adaptive LASSO Thresholding Function}
\usage{
adaptiveLassoThreshold(entry, lambda, n)
}
\arguments{
\item{entry}{A \code{numeric} entry in a covariance matrix estimate.}

\item{lambda}{A non-negative \code{numeric} defining the amount of
thresholding applied to each element of \code{dat}'s sample covariance
matrix.}

\item{n}{A non-negative \code{numeric} defining the adaptive weight
applied to each element of \code{dat}'s sample covariance matrix.}
}
\value{
A regularized \code{numeric}.
}
\description{
\code{adaptiveLassoThreshold()} applies the adaptive LASSO
thresholding function to the entries of a \code{matrix}. In particular, it
is meant to be applied to sample covariance matrix
}
\keyword{internal}
