% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribute.R
\name{cvap_distribute}
\alias{cvap_distribute}
\title{Estimate CVAP at the Block Level}
\usage{
cvap_distribute(cvap, block)
}
\arguments{
\item{cvap}{cvap data at the block group level, using default settings of \code{get_cvap()}}

\item{block}{block data data for the Census before (or the same as) the year of the cvap data}
}
\value{
cvap tibble estimated at the block level
}
\description{
Assuming citizenship homogeneity within block group race/ethnicity, estimates
down from block groups to the block level, proportionally by group if possible,
otherwise by total population.
}
\examples{
\dontrun{
# Requires API set up with tidycensus
state <- 'DE'
cvap <- cvap_get(state)
de_block <- censable::build_dec(geography = 'block',
state = state, year = 2010, geometry = FALSE)
}
# Alternatively, using example data
state <- 'DE'
cvap <- cvap_get(state)
data('de_block')
cvap_block <- cvap_distribute(cvap, de_block)
}
\concept{distribute}
