% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-GutsRed.R
\name{GUTS-RED-models}
\alias{GUTS-RED-models}
\title{GUTS-RED models}
\description{
Reduced \emph{General Unified Threshold models of Survival} (GUTS) with stochastic
death (\emph{SD}) and individual tolerance (\emph{IT})
}
\details{
The TKTD models \emph{\link[=GUTS_RED_SD]{GUTS-RED-SD}} and \emph{\link[=GUTS_RED_IT]{GUTS-RED-IT}}
were described by EFSA (2018).
GUTS-RED models assume a one-compartment model which directly links
external concentration to the scaled damage. The scaled damage is given in
units of concentration, equal to the units of measurement in the external
medium, e.g. ug/L. The damage dynamics is connected to an individual hazard
state variable, resulting in simulated mortality when an internal damage
threshold is exceeded. The death mechanisms stochastic death (\emph{SD}) and
individual threshold (\emph{IT}) are extreme cases of the \emph{GUTS} theory.

For \emph{SD} models, the threshold parameter for lethal effects is fixed and
identical for all individuals of a group, meaning that the variance of the
threshold values is zero. Hence, the killing rate relates the probability of
a mortality event in proportion to the scaled damage. For \emph{IT} models,
the thresholds for effects are distributed among individuals of a group.
Mortality of an individual follows immediately once the individual's tolerance
is exceeded. Meaning in model terms that the killing rate is set to
infinity (EFSA 2018).
}
\section{State variables}{

The following list describes the default names and standard units of \emph{GUTS-RED}
state variables:
\itemize{
\item \code{D}, scaled damage (conc)
\item \code{H}, cumulative hazard (-)
}

The state variables are initialized with zero by default.
}

\section{SD model parameters}{

\itemize{
\item \code{kd}, dominant rate constant (time^-1)
\item \code{hb}, background hazard rate (time^-1)
\item \code{z}, threshold for effects (conc)
\item \code{kk}, killing rate constant (time^-1)
}
}

\section{IT model parameters}{

\itemize{
\item \code{kd}, dominant rate constant (time^-1)
\item \code{hb}, background hazard rate (time^-1)
\item \code{alpha}, median of thresholds (conc)
\item \code{beta}, shape parameter (-)
}
}

\section{Effects}{

The effect endpoint \code{L} (lethality) is available for \emph{GUTS-RED} models.
A value of zero (\code{0.0}) denotes \emph{no effect} on organism survival. A value of
one (\code{1.0}) denotes a lethality rate of 100\%, i.e. no survivors.

The survival probability \code{S} is available in the return value of \code{\link[=simulate]{simulate()}}.
}

\references{
EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, et al., 2018: \emph{Scientific Opinion on the
state of the art of Toxicokinetic/Toxicodynamic (TKTD) effect models for
regulatory risk assessment of pesticides for aquatic organisms}. EFSA Journal 2018;
16(8):5377, 188 pp. \doi{10.2903/j.efsa.2018.5377}
}
\seealso{
Other GUTS-RED models: 
\code{\link{GUTS_RED_IT}()},
\code{\link{GUTS_RED_SD}()}

Other scenarios: 
\code{\link{Algae-models}},
\code{\link{DEB-models}},
\code{\link{Lemna-models}},
\code{\link{Macrophyte-models}},
\code{\link{Myriophyllum-models}},
\code{\link{Scenarios}},
\code{\link{Transferable}}
}
\concept{GUTS-RED models}
\concept{scenarios}
