% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/man-macrophytes.R
\name{Macrophyte-models}
\alias{Macrophyte-models}
\title{Macrophyte models}
\description{
Population models of standard test macrophytes, such as \emph{Lemna spp.}
}
\details{
Available macrophyte models:
\itemize{
\item \link[=Lemna-models]{Lemna}
\item \link[=Myrio]{Myriophyllum}
}
}
\section{Biomass transfer}{

Models supporting biomass transfer can be instructed to move a fixed amount
of biomass to a new medium after a period of time. This feature replicates
a procedure occurring in e.g. \emph{Lemna} effect studies and may be necessary to
recreate study results.

The biomass transfer feature assumes that always a fixed amount of
biomass is transferred. Transfers can occur at any fixed point in time or
in regular intervals. During a transfer, the biomass is reset to the
transferred amount and additional compartments can be scaled 1:1 accordingly,
to e.g. reflect the change in internal toxicant mass when biomass is modified.
Transfer settings can be modified using \code{\link[=set_transfer]{set_transfer()}}.

If a transfer occurs, simulation results of that time point will report the model state
\strong{before} the transfer. Be aware that if transfers are defined using the
\code{interval} argument, the transfers will always occur relative to time point
zero (\code{t = 0}). As an example, setting a regular transfer of seven days,
\code{interval =  7}, will result at transfers occurring at time points which are
integer multiplicates of seven, such as \code{t=0}, \code{t=7}, \code{t=14} and so forth.
The starting and end times of a scenario do not influece \strong{when} a regular
transfer occurs, only \strong{if} it occurs.
}

\seealso{
\link{Scenarios}

Other macrophyte models: 
\code{\link{Lemna_SETAC}()},
\code{\link{Lemna_Schmitt}()},
\code{\link{Myrio}()},
\code{\link{Myrio_log}()}

Other models: 
\code{\link{Algae-models}},
\code{\link{DEB-models}},
\code{\link{GUTS-RED-models}},
\code{\link{Lemna-models}},
\code{\link{Myriophyllum-models}}
}
\concept{macrophyte models}
\concept{models}
