% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxhull.R
\name{hullSummary}
\alias{hullSummary}
\title{Summary of 3D convex hull}
\usage{
hullSummary(hull)
}
\arguments{
\item{hull}{an output of \code{\link{cxhull}} applied to 3D points and 
with the option \code{triangulate=TRUE}}
}
\value{
A list with the vertices and the facets.
}
\description{
Summary of a triangulated 3D convex hull
}
\examples{
library(cxhull)
# pyramid
pts <- rbind(
  c(0, 0, 0), 
  c(1, 0, 0), 
  c(1, 1, 0), 
  c(0.5, 0.5, 1), 
  c(0.5, 0.5, 0.9),
  c(0, 1, 0)
)
hull <- cxhull(pts, triangulate = TRUE)
hullSummary(hull)
}
