<!-- README.md is generated from README.Rmd. Please edit that file -->
[![Build Status](https://travis-ci.org/hrbrmstr/cymruservices.svg)](https://travis-ci.org/hrbrmstr/cymruservices) [![Project Status: Active - The project has reached a stable, usable state and is being actively developed.](http://www.repostatus.org/badges/0.1.0/active.svg)](http://www.repostatus.org/#active) [![CRAN\_Status\_Badge](http://www.r-pkg.org/badges/version/cymruservices)](http://cran.r-project.org/package=cymruservices) ![downloads](http://cranlogs.r-pkg.org/badges/grand-total/cymruservices/)

![img](dragonr.jpg)

cymruservices is an R package that provides interfaces to various [Team Cymru Services](http://www.team-cymru.org/services.html) including:

-   [The Bogon Reference](http://www.team-cymru.org/bogon-reference.html)
-   [The IP to ASN Mapping Project](http://www.team-cymru.org/IP-ASN-mapping.html)
-   [The Malware Hash Registry](http://www.team-cymru.org/MHR.html)

The following functions are implemented:

-   `bulk_origin`: Retrieves BGP Origin ASN info for a list of IPv4 addresses
-   `bulk_origin_asn`: Retrieves BGP Origin ASN info for a list of ASN ids
-   `bulk_peer`: Retrieves BGP Peer ASN info for a list of IPv4 addresses
-   `ipv4_bogons`: Retrieve list of IPv4 "full bogons" from Team Cymru webservice
-   `ipv6_bogons`: Retrieve list of IPv6 "full bogons" from Team Cymru webservice
-   `malware_hash`: Retrieves malware hash metadata from the Malware Hash Registry

### News

-   Version 0.2.0 `timeout` parameter added to `whois`-based functions
-   Version 0.1.0 is on CRAN
-   Version 0.1.0.9999 released

### Installation

``` r
devtools::install_github("hrbrmstr/cymruservices")
# OR
install.packages("cymruservices")
```

### Usage

``` r
library(cymruservices)

# current verison
packageVersion("cymruservices")
#> [1] '0.2.0'
```

### Test Results

``` r
library(cymruservices)
library(testthat)

date()

# only using `force=TRUE` to ensure output for the example
# see the help for each function to see why this is a bad
# idea to run force all the time
head(ipv4_bogons(force=TRUE))

head(ipv6_bogons(force=TRUE))

bulk_origin(c("68.22.187.5", "207.229.165.18", "198.6.1.65"))

bulk_peer(c("68.22.187.5", "207.229.165.18", "198.6.1.65"))

bulk_origin_asn(c(22822, 1273, 2381, 2603, 2914, 3257, 3356, 11164,
                  174, 286, 1299, 2914, 3257, 3356, 3549, 22822))

malware_hash(c("1250ac278944a0737707cf40a0fbecd4b5a17c9d",
              "7697561ccbbdd1661c25c86762117613",
              "cbed16069043a0bf3c92fff9a99cccdc",
              "e6dc4f4d5061299bc5e76f5cd8d16610",
              "e1112134b6dcc8bed54e0e34d8ac272795e73d74"))

test_dir("tests/")
```

### Code of Conduct

Please note that this project is released with a [Contributor Code of Conduct](CONDUCT.md). By participating in this project you agree to abide by its terms.
