% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/parameters.R
\name{Pi}
\alias{Pi}
\title{Parameter transformation (implicit)}
\usage{
Pi(trafo, parameters = NULL, compile = FALSE)
}
\arguments{
\item{trafo}{Named character vector defining the equations to be set to zero.
Names correspond to dependent variables.}

\item{parameters}{Character vector, the independent variables.}

\item{compile}{Logical, compile the function (see \link{funC0})}
}
\value{
a function \code{p2p(p, fixed = NULL, deriv = TRUE)} representing the parameter
transformation. Here, \code{p} is a named numeric vector with the values of the outer parameters,
\code{fixed} is a named numeric vector with values of the outer parameters being considered
as fixed (no derivatives returned) and \code{deriv} is a logical determining whether the Jacobian
of the parameter transformation is returned as attribute "deriv".
}
\description{
Parameter transformation (implicit)
}
\details{
Usually, the equations contain the dependent variables, the independent variables and
other parameters. The argument \code{p} of \code{p2p} must provide values for the independent
variables and the parameters but ALSO FOR THE DEPENDENT VARIABLES. Those serve as initial guess
for the dependent variables. The dependent variables are then numerically computed by
\link[rootSolve]{multiroot}. The Jacobian of the solution with respect to dependent variables
and parameters is computed by the implicit function theorem. The function \code{p2p} returns
all parameters as they are with corresponding 1-entries in the Jacobian.
#'
}
\examples{
\dontrun{
########################################################################
## Example 1: Steady-state trafo
########################################################################
f <- c(A = "-k1*A + k2*B",
       B = "k1*A - k2*B")
P.steadyState <- Pi(f, "A")

p.outerValues <- c(k1 = 1, k2 = 0.1, A = 10, B = 1)
P.steadyState(p.outerValues)

########################################################################
## Example 2: Steady-state trafo combined with log-transform
########################################################################
f <- c(A = "-k1*A + k2*B",
       B = "k1*A - k2*B")
P.steadyState <- Pi(f, "A")

logtrafo <- c(k1 = "exp(logk1)", k2 = "exp(logk2)", A = "exp(logA)", B = "exp(logB)")
P.log <- P(logtrafo)

p.outerValue <- c(logk1 = 1, logk2 = -1, logA = 0, logB = 0)
(P.log)(p.outerValue)
(P.steadyState \%o\% P.log)(p.outerValue)
}
}
\seealso{
\link{P} for explicit parameter transformations and
\link{concatenation} for the concatenation of parameter transformations
}

