% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tools.R
\name{funC0}
\alias{funC0}
\title{Evaluation of algebraic expressions defined by characters}
\usage{
funC0(x, compile = TRUE)
}
\arguments{
\item{x}{Name character vector, the algebraic expressions}

\item{compile}{Logical. The function is either compiled (requires the \code{inline} package) or
evaluated in raw R.}
}
\value{
A prediction function \code{f(mylist)} where \code{mylist} is a list of numeric vectors that can
be coerced into a matrix. The names correspond to the symbols used in the algebraic expressions. The
function \code{f} returns a matrix.
}
\description{
Evaluation of algebraic expressions defined by characters
}
\examples{
\dontrun{
myfun <- funC0(c(x = "x", y = "a*x^4 + b*x^2 + c"))
out <- myfun(list(a = -1, b = 2, c = 3, x = seq(-2, 2, .1)))
plot(out[, 1], out[, 2])
}
}

