% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/parameters.R
\name{\%o\%}
\alias{\%o\%}
\alias{concatenation}
\title{Concatenation of parameter transformations}
\usage{
p1 \%o\% p2
}
\arguments{
\item{p1}{Return value of \link{P} or \link{Pi}}

\item{p2}{Return value of \link{P} or \link{Pi}}
}
\value{
A function \code{p2p(p, fixed = NULL, deriv = TRUE)}, the concatenation of \code{p1} and
\code{p2}.
}
\description{
Concatenation of parameter transformations
}
\examples{
\dontrun{
#' ########################################################################
## Example: Steady-state trafo combined with log-transform
########################################################################
f <- c(A = "-k1*A + k2*B",
       B = "k1*A - k2*B")
P.steadyState <- Pi(f, "A")

logtrafo <- c(k1 = "exp(logk1)", k2 = "exp(logk2)", A = "exp(logA)", B = "exp(logB)")
P.log <- P(logtrafo)

p.outerValue <- c(logk1 = 1, logk2 = -1, logA = 0, logB = 0)
(P.log)(p.outerValue)
(P.steadyState \%o\% P.log)(p.outerValue)
}
}

