% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remoteComputing.R
\name{runbg}
\alias{runbg}
\title{Run an R expression in the background (only on UNIX)}
\usage{
runbg(..., machine = "localhost", filename = NULL, input = ls(.GlobalEnv),
  compile = FALSE, wait = FALSE)
}
\arguments{
\item{...}{Some R code}

\item{machine}{Character vector, e.g. \code{"localhost"} or \code{"knecht1.fdm.uni-freiburg.de"}
or \code{c(localhost, localhost)}.}

\item{filename}{Character, defining the filename of the temporary file. Random
file name ist chosen if NULL.}

\item{input}{Character vector, the objects in the workspace that are stored
into an R data file and copied to the remove machine.}

\item{compile}{Logical. If \code{TRUE}, C files are copied and compiled on the remote machine.
Otherwise, the .so files are copied.}

\item{wait}{Logical. Wait until executed. If \code{TRUE}, the code checks if the result file
is already present in which case it is loaded. If not present, \code{runbg()} starts, produces
the result and loads it as \code{.runbgOutput} directly into the workspace. If \code{wait = FALSE},
\code{runbg()} starts in the background and the result is only loaded into the workspace
when the \code{get()} function is called, see Value section.}
}
\value{
List of functions \code{check}, \code{get()} and \code{purge()}. 
\code{check()} checks, if the result is ready.
\code{get()} copies the result file
to the working directory and loads it into the workspace as an object called \code{.runbgOutput}. 
This object is a list named according to the machines that contains the results returned by each
machine.
\code{purge()} deletes the temporary folder
from the working directory and the remote machines.
}
\description{
Generate an R code of the expression that is copied via \code{scp}
to any machine (ssh-key needed). Then collect the results.
}
\details{
\code{runbg()} generates a workspace from the \code{input} argument
and copies the workspace and all C files or .so files to the remote machines via
\code{scp}. This will only work if *an ssh-key had been generated and added
to the authorized keys on the remote machine*. On the remote machine, the script
will attempt to load all packages that had been loaded in the local R session.
This means that *all loaded packages must be present on the remote machine*. The
code snippet, i.e. the \code{...} argument, can include several intermediate results
but only the last call which is not redirected into a variable is returned via the
variable \code{.runbgOutput}, see example below.
}
\examples{
\dontrun{
out_job1 <- runbg({
         M <- matrix(rnorm(1e2), 10, 10)
         solve(M)
         }, machine = c("localhost", "localhost"), filename = "job1")
out_job1$check()          
out_job1$get()
result <- .runbgOutput
print(result)
out_job1$purge()
}
}

