% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{Xt}
\alias{Xt}
\title{Generate a prediction function that returns times}
\usage{
Xt(condition = NULL)
}
\arguments{
\item{condition}{either NULL (generic prediction for any condition) or a character, denoting
the condition for which the function makes a prediction.}
}
\value{
Object of class \link{prdfn}.
}
\description{
Function to deal with non-ODE models within the framework of dMod. See example.
}
\examples{
x <- Xt()
g <- Y(c(y = "a*time^2+b"), f = NULL, parameters = c("a", "b"))

times <- seq(-1, 1, by = .05)
pars <- c(a = .1, b = 1)

plot((g*x)(times, pars))
}
