% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dabest}
\alias{plot.dabest}
\title{Estimation Plot}
\usage{
\method{plot}{dabest}(x, ..., color.column = NULL, palette = "Set1",
  float.contrast = TRUE, slopegraph = TRUE,
  group.summaries = "mean_sd", rawplot.type = c("swarmplot",
  "sinaplot"), rawplot.ylim = NULL, rawplot.ylabel = NULL,
  rawplot.markersize = 2, rawplot.groupwidth = 0.3,
  effsize.ylim = NULL, effsize.ylabel = NULL, effsize.markersize = 4,
  theme = ggplot2::theme_classic(), tick.fontsize = 11,
  axes.title.fontsize = 14, swarmplot.params = NULL,
  sinaplot.params = NULL, slopegraph.params = NULL)
}
\arguments{
\item{x}{A \code{dabest} object, generated by the function of the same name.}

\item{...}{Signature for S3 generic function.}

\item{color.column}{default \code{NULL}. This is a column in the data.frame
passed to the \code{dabest} function. This column will be treated as a
\link{factor} and used to color the datapoints in the rawdata swarmplot.}

\item{palette}{default "Set1". Accepts any one of the ggplot2 palettes.
See the "Palettes" section in \link{scale_color_brewer}.}

\item{float.contrast}{default \code{TRUE}.  If \code{idx} in the
\code{dabest} object contains only 2 groups, \code{float.contrast = TRUE}
will plot the effect size and the bootstrap confidence interval in a
horizontally-aligned axes (also known as a
\href{https://bit.ly/2NhqUAb}{Gardner-Altman plot.})}

\item{slopegraph}{boolean, default \code{TRUE}. If the \code{dabest} object
contains paired comparisons, \code{slopegraph = TRUE} will plot the rawdata
as a \href{http://charliepark.org/slopegraphs/}{Tufte slopegraph}.}

\item{group.summaries}{"mean_sd", "median_quartiles", or \code{NULL}. Plots
the summary statistics for each group. If 'mean_sd', then the mean and
standard deviation of each group is plotted as a gapped line beside each
group. If 'median_quartiles', then the median and 25th & 75th percentiles
of each group is plotted instead. If \code{group.summaries = NULL}, the
summaries are not shown.}

\item{rawplot.type}{default "beeswarm". Accepts either "beeswarm" or
"sinaplot". See \link{geom_quasirandom} and \link{geom_sina} for more
information.}

\item{rawplot.ylim}{default \code{NULL}. Enter a custom y-limit for the
rawdata plot. Accepts a vector of length 2 (e.g. c(-50, 50)) that will be
passed along to \link{coord_cartesian}.}

\item{rawplot.ylabel}{default \code{NULL}. Accepts a string that is used to
label the rawdata y-axis. If \code{NULL}, the column name passed to
\code{y} is used.}

\item{rawplot.markersize}{default 2. This is the size (in points) of the dots
used to plot the individual datapoints. There are 72 points in one inch.
See \href{https://en.wikipedia.org/wiki/Point_(typography)}{this article}
for more info.}

\item{rawplot.groupwidth}{default 0.3. This is the maximum amount of spread
(in the x-direction) allowed, for each group.}

\item{effsize.ylim}{default \code{NULL}. Enter a custom y-limit for the
effect size plot. This parameter is ignored if \code{float.contrast =
TRUE}. Accepts a vector of length 2 (e.g. \code{c(-50, 50)}) that will be
passed along to \link{coord_cartesian}.}

\item{effsize.ylabel}{default \code{NULL}. Accepts a string that is used to
label the effect size y-axis. If \code{NULL}, this axes will be labeled
"(un)paired func difference" , where \code{func} is the function passed
to \code{dabest}.}

\item{effsize.markersize}{default 4. This is the size (in points) of the dots
used to indicate the effect size.}

\item{theme}{default \link{theme_classic}.}

\item{tick.fontsize}{default 11. This controls the font size (in points) of
all tick labels.}

\item{axes.title.fontsize}{default 14. This determines the font size (in
points) of the axes titles.}

\item{swarmplot.params}{default \code{NULL}. Supply list of
\code{keyword = value} pairs to \link{geom_quasirandom}.}

\item{sinaplot.params}{default \code{NULL}. Supply list of
\code{keyword = value} pairs to \code{ggforce::geom_sina()}.}

\item{slopegraph.params}{default \code{NULL}. Supply list of
\code{keyword = value} pairs to \code{ggplot2::geom_line()}. This
controls the appearance of the lines plotted for a paired slopegraph.}
}
\value{
A \code{ggplot} object.
}
\description{
An estimation plot has two key features.
\enumerate{
  \item{It presents all datapoints as a
  \href{https://github.com/eclarke/ggbeeswarm#introduction}{swarmplot} or
  \href{https://CRAN.R-project.org/package=sinaplot}{sinaplot},
  which orders each point to display the underlying distribution.}
  \item{It presents the effect size as a bootstrap 95 percent confidence
        interval on a separate but aligned axes.}
}
Estimation plots emerge from estimation statistics, an intuitive framework
that avoids the pitfalls of significance testing. It uses familiar
statistical concepts: means, mean differences, and error bars.
More importantly, it focuses on the effect size of one's
experiment/intervention, as opposed to a false dichotomy engendered
by \emph{P} values.
This function takes the output of the \code{\link{dabest}} function
and produces an estimation plot.
}
\section{References}{

\href{https://doi.org/10.1101/377978}{Moving beyond P values: Everyday data
analysis with estimation plots.} (2018) Joses Ho, Tayfun Tumkaya, Sameer
Aryal, Hyungwon Choi, Adam Claridge-Chang
}

\examples{
# Performing unpaired (two independent groups) analysis.
unpaired_mean_diff <- dabest(iris, Species, Petal.Width,
                             idx = c("setosa", "versicolor"),
                             paired = FALSE)

# Create a Gardner-Altman estimation plot.
plot(unpaired_mean_diff)



# Comparing versicolor and virginica petal width to setosa petal width.
shared_control_data <- dabest(iris, Species, Petal.Width,
                              idx = c("setosa", "versicolor", "virginica")
                              )

# Create a Cumming estimation plot.
plot(shared_control_data)

}
\seealso{
The \code{\link{dabest}} function.

Run \code{vignette("Using dabestr", package = "dabestr")} in the console to
read more about using parameters to control the plot features.
}
