#' patch data
#'
#' Patch data with a diff generated by \code{\link{diff_data}}
#'@example ./examples/patchdata.R
#'@param data \code{data.frame} that should be patched
#'@param patch generated with diff_data
#'@return \code{data.frame} that has been patched.
#'@export
patch_data <- function(data, patch){
  stopifnot(inherits(patch, "TableView"))

  ctx <- patch$ctx

  mode <- patch$mode %||% sapply(data, storage.mode)
  is_factor <- patch$is_factor %||% sapply(data, is.factor)
  levels <- patch$levels

  tv <- TableView(ctx, data)
  ctx$call("patch_data", JS(tv$var_name), JS(patch$var_name))

  new_data <- tv$get_matrix()

  patch_matrix <- patch$get_matrix()
  if(is.null(colnames(patch_matrix)) || colnames(patch_matrix)[1] != "@@")
  {
    colnames(new_data) <- unlist(new_data[1,])
    new_data           <- as.data.frame(new_data[-1, ,drop=FALSE], stringsAsFactors = FALSE)
  }

  for (n in names(mode)){
    if (is_factor[n]){
      if (is.null(levs <- levels[[n]])){
        new_data[[n]] <- factor(new_data[[n]])
      } else {
        new_data[[n]] <- factor(new_data[[n]], levels=levs)
      }
    } else {
      storage.mode(new_data[[n]]) <- mode[n]
    }
  }
  new_data
}

