% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_dt_pca.R
\name{dt_pca}
\alias{dt_pca}
\title{PCA}
\usage{
dt_pca(attribute = NULL, components = NULL)
}
\arguments{
\item{attribute}{target attribute to model building}

\item{components}{number of components for PCA}
}
\value{
obj
}
\description{
PCA (Principal Component Analysis) is an unsupervised
dimensionality reduction technique used in data analysis and
machine learning. It transforms a dataset of possibly
correlated variables into a new set of uncorrelated
variables called principal components.
}
\examples{
mypca <- dt_pca("Species")
# Automatically fitting number of components
mypca <- fit(mypca, iris)
iris.pca <- transform(mypca, iris)
head(iris.pca)
head(mypca$pca.transf)
# Manual establishment of number of components
mypca <- dt_pca("Species", 3)
mypca <- fit(mypca, datasets::iris)
iris.pca <- transform(mypca, iris)
head(iris.pca)
head(mypca$pca.transf)
}
