% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_knn.R
\name{cla_knn}
\alias{cla_knn}
\title{K Nearest Neighbor Classification}
\usage{
cla_knn(attribute, slevels, k = 1)
}
\arguments{
\item{attribute}{attribute target to model building.}

\item{slevels}{possible values for the target classification.}

\item{k}{a vector of integers indicating the number of neighbors to be considered.}
}
\value{
returns a knn object.
}
\description{
Classifies using the K-Nearest Neighbor algorithm.
It wraps the class library.
}
\examples{
data(iris)
slevels <- levels(iris$Species)
model <- cla_knn("Species", slevels, k=3)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, iris)
train <- sr$train
test <- sr$test

model <- fit(model, train)

prediction <- predict(model, test)
predictand <- adjust_class_label(test[,"Species"])
test_eval <- evaluate(model, predictand, prediction)
test_eval$metrics
}
