% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.dist.pop.r
\name{gl.dist.pop}
\alias{gl.dist.pop}
\title{Calculates a distance matrix for populations with SNP genotypes in a
 genlight object}
\usage{
gl.dist.pop(
  x,
  as.pop = NULL,
  method = "euclidean",
  scale = FALSE,
  type = "dist",
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight containing [required].}

\item{as.pop}{Temporarily assign another locus metric as the population for
the purposes of deletions [default NULL].}

\item{method}{Specify distance measure [default euclidean].}

\item{scale}{If TRUE and method='Euclidean', the distance will be scaled to 
fall in the range [0,1] [default FALSE].}

\item{type}{Specify the type of output, dist or matrix [default dist]}

\item{plot.display}{If TRUE, resultant plots are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{List of two color names for the borders and fill of the
plots [default c("#2171B5","#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
An object of class 'dist' giving distances between populations
}
\description{
This script calculates various distances between populations based on allele
frequencies (SNP genotypes) or frequency of presences in PA (SilicoDArT) data
}
\details{
The distance measure can be one of 'euclidean', 'fixed-diff', 'reynolds',
'nei' and 'chord'. Refer to the documentation of functions in
  https://doi.org/10.1101/2023.03.22.533737 for algorithms
  and definitions.
}
\examples{
 \donttest{
# SNP genotypes
D <- gl.dist.pop(possums.gl, method='euclidean')
D <- gl.dist.pop(possums.gl, method='euclidean',scale=TRUE)
D <- gl.dist.pop(possums.gl, method='nei')
D <- gl.dist.pop(possums.gl, method='reynolds')
D <- gl.dist.pop(possums.gl, method='chord')
D <- gl.dist.pop(possums.gl, method='fixed-diff')
#Presence-Absence data [only 10 individuals due to speed]
D <- gl.dist.pop(testset.gs[1:10,], method='euclidean')
}

}
\seealso{
Other distance: 
\code{\link{gl.dist.ind}()},
\code{\link{gl.fdsim}()},
\code{\link{utils.dist.ind.snp}()}
}
\author{
author(s): Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{distance}
