% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.ld.map.r
\name{gl.report.ld.map}
\alias{gl.report.ld.map}
\title{Calculates pairwise linkage disequilibrium by population}
\usage{
gl.report.ld.map(
  x,
  ld.max.pairwise = NULL,
  maf = 0.05,
  ld.stat = "R.squared",
  ind.limit = 10,
  stat.keep = "AvgPIC",
  ld.threshold.pops = 0.2,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.file = NULL,
  plot.dir = NULL,
  histogram.colors = NULL,
  boxplot.colors = NULL,
  bins = 50,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{ld.max.pairwise}{Maximum distance in number of base pairs at which LD 
should be calculated [default NULL].}

\item{maf}{Minor allele frequency (by population) threshold to filter out 
loci. If a value > 1 is provided it will be interpreted as MAC (i.e. the
 minimum number of times an allele needs to be observed) [default 0.05].}

\item{ld.stat}{The LD measure to be calculated: "LLR", "OR", "Q", "Covar",
"D.prime", "R.squared", and "R". See \code{\link[snpStats]{ld}}
 (package snpStats) for details [default "R.squared"].}

\item{ind.limit}{Minimum number of individuals that a population should
contain to take it in account to report loci in LD [default 10].}

\item{stat.keep}{Name of the column from the slot \code{loc.metrics} to be
used to choose SNP to be kept [default "AvgPIC"].}

\item{ld.threshold.pops}{LD threshold to report in the plot of "Number of 
populations in which the same SNP pair are in LD" [default 0.2].}

\item{plot.display}{If TRUE, histograms of base composition are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{histogram.colors}{Vector with two color names for the borders and fill
[default NULL].}

\item{boxplot.colors}{A color palette for box plots by population or a list
 with as many colors as there are populations in the dataset
[default NULL].}

\item{bins}{Number of bins to display in histograms [default 50].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A dataframe with information for each SNP pair in LD.
}
\description{
This function calculates pairwise linkage disequilibrium (LD) by population 
using the function \code{\link[snpStats]{ld}} (package snpStats).
If SNPs are not mapped to a reference genome, the parameter
 \code{ld.max.pairwise}
 should be set as NULL (the default). In this case, the 
function will assign the same chromosome ("1") to all the SNPs in the dataset
 and assign a sequence from 1 to n loci as the position of each SNP. The 
 function will then calculate LD for all possible SNP pair combinations. 
If SNPs are mapped to a reference genome, the parameter 
\code{ld.max.pairwise}
 should be filled out (i.e. not NULL). In this case, the
 information for SNP's position should be stored in the genlight accessor
  "@position" and the SNP's chromosome name in the accessor "@chromosome"
   (see examples). The function will then calculate LD within each chromosome
    and for all possible SNP pair combinations within a distance of
     \code{ld.max.pairwise}.
}
\details{
This function reports LD between SNP pairs by population. 
The function \code{\link{gl.filter.ld}} filters out the SNPs in LD using as
input the results of \code{\link{gl.report.ld.map}}. The actual number of 
SNPs to be filtered out depends on the parameters set in the function 
\code{\link{gl.filter.ld}}.
Boxplots of LD by population and
a histogram showing LD frequency are presented.
}
\examples{
require("dartR.data")
x <- platypus.gl
x <- gl.filter.callrate(x,threshold = 1)
x <- gl.filter.monomorphs(x)
x$position <- x$other$loc.metrics$ChromPos_Platypus_Chrom_NCBIv1
x$chromosome <- as.factor(x$other$loc.metrics$Chrom_Platypus_Chrom_NCBIv1)
ld_res <- gl.report.ld.map(x,ld.max.pairwise = 10000000)
}
\seealso{
\code{\link{gl.filter.ld}}

Other graphics: 
\code{\link{gl.colors}()},
\code{\link{gl.map.interactive}()},
\code{\link{gl.plot.heatmap}()},
\code{\link{gl.select.colors}()},
\code{\link{gl.select.shapes}()},
\code{\link{gl.smearplot}()},
\code{\link{gl.tree.nj}()}
}
\author{
Custodian: Luis Mijangos -- Post to
 \url{https://groups.google.com/d/forum/dartr}
}
\concept{graphics}
