% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.vcfr2genlight.polyploid.R
\name{utils.vcfr2genlight.polyploid}
\alias{utils.vcfr2genlight.polyploid}
\title{Utility function to convert polyploid vcfR object as genlight}
\usage{
utils.vcfr2genlight.polyploid(x, n.cores = 1, mode2 = mode)
}
\arguments{
\item{x}{Name of the vcfR object [defined in function \code{\link{gl.read.vcf}}].}

\item{n.cores}{Number of cores [default 1]}

\item{mode2}{genotype: all heterozygous sites will be coded as 1 regardless ploidy level, 
dosage: sites will be codes as copy number of alternate allele [defined in function \code{\link{gl.read.vcf}}].}
}
\value{
genlight object
}
\description{
WARNING: UTILITY SCRIPTS ARE FOR INTERNAL USE ONLY AND SHOULD NOT BE USED BY END USERS AS THEIR USE OUT OF CONTEXT COULD LEAD TO UNPREDICTABLE OUTCOMES.
}
\details{
This function uses parameters from \code{\link{gl.read.vcf}} for conversion
Note also that this function checks to see if there are input of mode, missing input of mode 
will issued the user with a error. "Dosage" mode of this function assign ploidy levels as maximum copy number of alternate alleles. 
Please carefully check the data if "dosage" mode is used. (codes were modified from
'vcfR2genlight' in vcfR packge to convert polyploid data)
}
\examples{
\dontrun{
datatype <- utils.vcfr2genlight.polyploid(x=vcfr, mode2="genotype")
}
}
\references{
\itemize{
\item Knaus, B. J., & Grunwald, N. J. (2017). 
vcfr: a package to manipulate and visualize variant call format data in R. 
Molecular ecology resources, 17(1), 44-53.
\item Knaus, B. J., Grunwald, N. J., Anderson, E. C., Winter, D. J., 
Kamvar, Z. N., & Tabima, J. F. (2023). Package 'vcfR'.
\href{https://github.com/knausb/vcfR/blob/master/R/vcfR_conversion.R}{vcfR}
}
}
\seealso{
Other utilities: 
\code{\link{gl.alf}()},
\code{\link{utils.check.datatype}()},
\code{\link{utils.dart2genlight}()},
\code{\link{utils.dist.binary}()},
\code{\link{utils.flag.start}()},
\code{\link{utils.hamming}()},
\code{\link{utils.het.pop}()},
\code{\link{utils.impute}},
\code{\link{utils.is.fixed}()},
\code{\link{utils.jackknife}()},
\code{\link{utils.n.var.invariant}()},
\code{\link{utils.plot.save}()},
\code{\link{utils.read.fasta}()},
\code{\link{utils.read.ped}()},
\code{\link{utils.recalc.avgpic}()},
\code{\link{utils.recalc.callrate}()},
\code{\link{utils.recalc.freqhets}()},
\code{\link{utils.recalc.freqhomref}()},
\code{\link{utils.recalc.freqhomsnp}()},
\code{\link{utils.recalc.maf}()},
\code{\link{utils.reset.flags}()},
\code{\link{utils.transpose}()}
}
\author{
Custodian: Ching Ching Lau -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{utilities}
