% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.excess.het.r
\name{gl.filter.excess.het}
\alias{gl.filter.excess.het}
\title{Filters excessively-heterozygous loci from a genlight object}
\usage{
gl.filter.excess.het(
  x,
  Yates = FALSE,
  mono.rm = FALSE,
  recalc = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{A genlight object containing the SNP genotypes [required].}

\item{Yates}{Whether to use Yates's continuity correction [default FALSE].}

\item{mono.rm}{Remove monomorphic loci after analysis is complete
[default FALSE].}

\item{recalc}{Recalculate the locus metadata statistics if any individuals
are deleted in the filtering [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
Returns unaltered genlight object
}
\description{
Calculates excess of heterozygosity in a genlight object and remove those loci
}
\examples{
filtered.gl <- gl.filter.excess.het(x = LBP, Yates = TRUE)
# Use below function to output information of the loci with Yates's continuity correction specified 
filtered.table <- gl.report.excess.het(x = LBP, Yates = TRUE)
}
\references{
\itemize{
\item https://github.com/drobledoruiz/conservation_genomics/tree/main/filter.excess.het
\item Robledo‐Ruiz, D. A., Austin, L., Amos, J. N., Castrejón‐Figueroa, J., Harley, D. K., Magrath, M. J., Sunnucks, P. & Pavlova, A. (2023). 
Easy‐to‐use R functions to separate reduced‐representation genomic datasets into sex‐linked and autosomal loci, 
and conduct sex assignment. Molecular Ecology Resources.
}
}
\seealso{
\code{\link{gl.filter.callrate}}

Other matched report: 
\code{\link{gl.report.allna}()},
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.maf}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.taglength}()}
}
\author{
Author(s): Jesús Castrejón-Figueroa, Diana A Robledo-Ruiz (Custodian: Ching Ching Lau) -- Post
to \url{https://groups.google.com/d/forum/dartr}
}
\concept{matched report}
