% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.merge.pop.r
\name{gl.merge.pop}
\alias{gl.merge.pop}
\title{Merges two or more populations in a dartR genlight object into one population}
\usage{
gl.merge.pop(x, old = NULL, new = NULL, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{old}{A list of populations to be merged [required].}

\item{new}{Name of the new population [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].}
}
\value{
A genlight object with the new population assignments.
}
\description{
Individuals are assigned to populations based on the specimen metadata data
file (csv) used with gl.read.dart().
This function assigns individuals from two nominated populations into a new
single population. It can also be used to rename populations.
The function works with both SNP and Tag P/A (silicoDArT) data.
The function returns a genlight object with the new population assignments.
}
\examples{
   gl <- gl.merge.pop(testset.gl, old=c('EmsubRopeMata','EmvicVictJasp'), new='Outgroup')
   
}
\seealso{
Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sim.genotypes}()},
\code{\link{gl.sort}()},
\code{\link{gl.subsample.ind}()},
\code{\link{gl.subsample.loc}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{data manipulation}
