% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.make.recode.ind.r
\name{gl.make.recode.ind}
\alias{gl.make.recode.ind}
\title{Create a proforma recode_ind file for reassigning individual (=specimen) names}
\usage{
gl.make.recode.ind(x, outfile = "default_recode_ind.csv")
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data, or the genind object containing the SilocoDArT data [required]}

\item{outfile}{-- name of the new proforma file [default default_recode_ind.csv]}
}
\value{
A vector containing the new individual names
}
\description{
Renaming individuals may be required when there have been errors in labelling arising
in the process from sample to DArT files. There may be occasions where renaming
individuals is required for preparation of figures. Caution needs to be exercised
because of the potential for breaking the "chain of evidence" between the samples themselves
and the analyses. REcoding individuals can be done with a recode table (csv).
}
\details{
This script facilitates 
the construction of a recode table by producing a proforma file with
current individual (=specimen) names in two identical columns. Edit the second
column to reassign individual names. Use keyword Delete to delete an individual.

Apply the recoding using gl.recode.ind(). Deleting individuals
can potentially generate monomorphic loci or loci with all
values missing. Clean this up with gl.filter.monomorphic().
}
\examples{
\dontrun{
result <- gl.make.recode.ind(gl, outfile="Emmac_recode_ind.csv")
}
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}

