% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.dist.binary.r
\name{utils.dist.binary}
\alias{utils.dist.binary}
\title{Calculate a distance matrix for individuals defined in an \{adegenet\} genlight object using binary P/A data (SilicoDArT)}
\usage{
utils.dist.binary(x, method = "simple", verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight containing the SNP genotypes [required]}

\item{method}{-- Specify distance measure [simple]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [2]}
}
\value{
An object of class 'dist' giving distances between individuals
}
\description{
This script calculates various distances between individuals based on Tag Presence/Absence data. #' 
 
The distance measure can be one of
 
 simple -- simple matching, both 1 or both 0 = 0; one 1 and the other 0 = 1. Presence and absence equally weighted.
 Jaccard -- ignores matching 0, both 1 = 0; one 1 and the other 0 = 1. Absences could be for different reasons.
 Dice -- both 0 = 0; both 1 = 2; one 1 and the other 0 = 1. Absences could be for different reasons. Sometimes called the Czekanowski or Sorensen distance.
 Phi -- binary analogue of the Pearson Correlation coefficient.
 
 One might choose to disregard or downweight absences in comparison with presences because the homology of absences is less clear (mutation at one or
 the other, or both restriction sites). Your call.
}
\examples{
D <- utils.dist.binary(testset.gs, method="Jaccard")
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
