% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2hiphop.r
\name{gl2hiphop}
\alias{gl2hiphop}
\title{Converts genlight objects to hiphop format}
\usage{
gl2hiphop(gl, verbose = NULL)
}
\arguments{
\item{gl}{-- name of the genlight object containing the SNP data}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
Dataframe containing all the genotyped individuals (offspring and potential parents) and their genotypes scored using bi-allelic markers.
}
\description{
This function exports genlight objects to the format used by the parentage assignment R package hiphop. Hiphop can be used for paternity and maternity assignment and outperforms conventional methods where closely related individuals occur in the pool of possible parents. The method compares the genotypes of offspring with any combination of potentials parents and scores the number of mismatches of these individuals at bi-allelic genetic markers (e.g. Single Nucleotide Polymorphisms).
}
\examples{
\donttest{
result <- gl2hiphop(testset.gl)
}
}
\references{
Cockburn, A., Penalba, J.V.,Jaccoud, D.,Kilian, A., Brouwer, L.,Double, M.C., Margraf, N., Osmond, H.L., van de Pol, M. and Kruuk, L.E.B.(in revision). HIPHOP: improved paternity assignment among close relatives using a simple exclusion method for bi-allelic markers. Molecular Ecology Resources, DOI to be added upon acceptance
}
\author{
Luis Mijangos (Post to \url{https://groups.google.com/d/forum/dartr})
}
