% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.dart2genlight.r
\name{utils.dart2genlight}
\alias{utils.dart2genlight}
\title{Convert DarT to genlight}
\usage{
utils.dart2genlight(
  dart,
  ind.metafile = NULL,
  covfilename = NULL,
  probar = TRUE,
  verbose = 2
)
}
\arguments{
\item{dart}{a dart object created via read.dart}

\item{ind.metafile}{optional file in csv format with metadata for each individual (see details for explanation)}

\item{covfilename}{depreciated, use parameter ind.metafile}

\item{probar}{show progress bar}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
a genlight object is returned. Including all available slots are filled. loc.names, ind.names, pop, lat, lon (if provided via the ind.metadata file)
}
\description{
converts a dart file (read via \code{read.dart}) into an genlight object \code{\link{adegenet}}. Internal function called by gl.read.dart
}
\details{
the ind.metadata file needs to have very specific headings. First an heading called id. Here the ids have to match the ids in the dart object \code{colnames(dart[[4]])}. The following column headings are optional. pop: specifies the population membership of each individual. lat and lon specify spatial coordinates (perferable in decimal degrees WGS1984 format). Additional columns with individual metadata can be imported (e.g. age, gender).
}
