% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sim.create.dispersal.r
\name{gl.sim.create_dispersal}
\alias{gl.sim.create_dispersal}
\title{Creates a dispersal file as input for the function gl.sim.WF.run}
\usage{
gl.sim.create_dispersal(
  number_pops,
  dispersal_type = "all_connected",
  number_transfers = 1,
  transfer_each_gen = 1,
  outpath = tempdir(),
  outfile = "dispersal_table.csv",
  verbose = NULL
)
}
\arguments{
\item{number_pops}{Number of populations [required].}

\item{dispersal_type}{One of: "all_connected", "circle" or "line"
[default "all_connected"].}

\item{number_transfers}{Number of dispersing individuals. This value can be .
modified by hand after the file has been created [default 1].}

\item{transfer_each_gen}{Interval of number of generations in which dispersal
occur. This value can be modified by hand after the file has been created
 [default 1].}

\item{outpath}{Path where to save the output file. Use outpath=getwd() or
outpath='.' when calling this function to direct output files to your working
 directory [default tempdir(), mandated by CRAN].}

\item{outfile}{File name of the output file [default 'dispersal_table.csv'].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
Writes csv file containing the dispersal variables for each pair of
populations to be used as input for the function \code{\link{gl.sim.WF.run}}.
}
\description{
This function writes a csv file called "dispersal_table.csv" which contains
 the dispersal variables for each pair of populations to be used as input for
  the function \code{\link{gl.sim.WF.run}}.

The values of the variables can be modified using the columns
"transfer_each_gen" and "number_transfers" of this file.

See documentation and tutorial for a complete description of the simulations.
These documents can be accessed by typing in the R console:
browseVignettes(package="dartR”)
}
\examples{
gl.sim.create_dispersal(number_pops=10)
}
\seealso{
\code{\link{gl.sim.WF.run}}

Other simulation functions: 
\code{\link{gl.sim.WF.run}()},
\code{\link{gl.sim.WF.table}()}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{simulation functions}
