% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.heterozygosity.r
\name{gl.filter.heterozygosity}
\alias{gl.filter.heterozygosity}
\title{Filters individuals with average heterozygosity greater than a
 specified upper threshold or less than a specified lower threshold}
\usage{
gl.filter.heterozygosity(x, t.upper = 0.7, t.lower = 0, verbose = NULL)
}
\arguments{
\item{x}{A genlight object containing the SNP genotypes [required].}

\item{t.upper}{Filter individuals > the threshold [default 0.7].}

\item{t.lower}{Filter individuals < the threshold [default 0].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
The filtered genlight object.
}
\description{
Calculates the observed heterozygosity for each individual in a genlight
object and filters individuals based on specified threshold values.
Use gl.report.heterozygosity to determine the appropriate thresholds.
}
\examples{
 result <- gl.filter.heterozygosity(testset.gl,t.upper=0.06,verbose=3)
 tmp <- gl.report.heterozygosity(result,method='ind')
}
\seealso{
Other filter functions: 
\code{\link{gl.filter.allna}()},
\code{\link{gl.filter.callrate}()},
\code{\link{gl.filter.hwe}()},
\code{\link{gl.filter.ld}()},
\code{\link{gl.filter.locmetric}()},
\code{\link{gl.filter.maf}()},
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.overshoot}()},
\code{\link{gl.filter.parent.offspring}()},
\code{\link{gl.filter.pa}()},
\code{\link{gl.filter.rdepth}()},
\code{\link{gl.filter.reproducibility}()},
\code{\link{gl.filter.secondaries}()},
\code{\link{gl.filter.sexlinked}()},
\code{\link{gl.filter.taglength}()}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{filter functions}
