% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.map.interactive.r
\name{gl.map.interactive}
\alias{gl.map.interactive}
\title{Creates an interactive map (based on latlon) from a genlight object}
\usage{
gl.map.interactive(
  x,
  matrix = NULL,
  standard = TRUE,
  symmetric = TRUE,
  pop.labels = TRUE,
  pop.labels.cex = 12,
  ind.circles = TRUE,
  ind.circle.cols = NULL,
  ind.circle.cex = 10,
  ind.circle.transparency = 0.8,
  palette_links = NULL,
  leg_title = NULL,
  provider = "Esri.NatGeoWorldMap",
  verbose = NULL
)
}
\arguments{
\item{x}{A genlight object (including coordinates within the latlon slot) 
[required].}

\item{matrix}{A distance matrix between populations or individuals. The
matrix is visualised as lines between individuals/populations. If matrix is
asymmetric two lines with arrows are plotted [default NULL].}

\item{standard}{If a matrix is provided line width will be standardised to be
between 1 to 10, if set to true, otherwise taken as given [default TRUE].}

\item{symmetric}{If a symmetric matrix is provided only one line is drawn
based on the lower triangle of the matrix. If set to false arrows indicating
the direction are used instead [default TRUE].}

\item{pop.labels}{Population labels at the center of the individuals of
populations [default TRUE].}

\item{pop.labels.cex}{Size of population labels [default 12].}

\item{ind.circles}{Should individuals plotted as circles [default TRUE].}

\item{ind.circle.cols}{Colors of circles. Colors can be provided as usual by 
names (e.g. "black") and are re-cycled. So a color c("blue","red") colors 
individuals alternatively between blue and red using the genlight object
 order of individuals. For transparency see parameter 
 ind.circle.transparency. Defaults to rainbow colors by population  if not
  provided. If you want to have your own colors for each population, check
   the platypus.gl example below.}

\item{ind.circle.cex}{(size or circles in pixels ) [default 10].}

\item{ind.circle.transparency}{Transparency of circles between 0=invisible 
and 1=no transparency. Defaults to 0.8.}

\item{palette_links}{Color palette for the links in case a matrix is provided
[default NULL].}

\item{leg_title}{Legend's title for the links in case a matrix is provided
[default NULL].}

\item{provider}{Passed to leaflet [default "Esri.NatGeoWorldMap"].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
plots a map
}
\description{
Creates an interactive map (based on latlon) from a genlight object
}
\details{
A wrapper around the \pkg{leaflet} package. For possible background 
maps check as specified via the provider:
\url{http://leaflet-extras.github.io/leaflet-providers/preview/index.html}

The palette_links argument can be any of the following:
A character vector of RGB or named colors. Examples: palette(), 
c("#000000", "#0000FF", "#FFFFFF"), topo.colors(10)

The name of an RColorBrewer palette, e.g. "BuPu" or "Greens".

The full name of a viridis palette: "viridis", "magma", "inferno", 
or "plasma".

A function that receives a single value between 0 and 1 and returns a color.
 Examples: colorRamp(c("#000000", "#FFFFFF"), interpolate = "spline").
}
\examples{
require("dartR.data")
gl.map.interactive(bandicoot.gl)
cols <- c("red","blue","yellow")[as.numeric(pop(platypus.gl))]
gl.map.interactive(platypus.gl, ind.circle.cols=cols, ind.circle.cex=10, 
ind.circle.transparency=0.5)
}
\author{
Bernd Gruber -- Post to \url{https://groups.google.com/d/forum/dartr}
}
