% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\docType{class}
\name{Node}
\alias{Node}
\title{Create a \code{data.tree} Structure With \code{Nodes}}
\format{An \code{\link{R6Class}} generator object}
\usage{
# n1 <- Node$new("Node 1")
}
\description{
\code{Node} is at the very heart of the \code{data.tree} package. All trees are constructed
by tying toghether \code{Node} objects.
}
\details{
Assemble \code{Node} objects into a \code{data.tree}
structure and use the traversal methods to set, get, and perform operations on it. Typically, you construct larger tree 
structures by converting from \code{data.frame}, \code{list}, or other formats.
As \code{Node} is object oriented, there are always two variations of methods:
\itemize{
  \item a.) OO style: \code{acme$Sort()}
  \item b.) traditional: \code{Sort(acme)}
}
This is only syntactical sugar, and the result of both variations is exactly the same. Other examples where this apply are \code{Set},
\code{Get}, \code{Do}, \code{Prune}, \code{Climb}, \code{Sort}, etc.
}
\section{Fields}{

\describe{
\item{\code{children}}{A list of child \code{Nodes}}

\item{\code{parent}}{The node's parent \code{Node}}
}}
\section{Methods}{


\describe{
  \item{\code{Node$new(name)}}{Creates a new \code{Node} called \code{name}. Often used to construct the root when creating trees programmatically.}
  \item{\code{AddChild(name)}}{Creates a new \code{Node} called \code{name} and adds it to this \code{Node} as a child.}
  \item{\code{AddChildNode(node)}}{Adds a \code{Node} as a child.}
  \item{\code{AddSibling(name)}}{Creates a new \code{Node} called \code{name} and adds it after this \code{Node} as a sibling.}
  \item{\code{AddSiblingNode(sibling)}}{Adds a new \code{Node} after this \code{Node}, as a sibling.}      
  \item{\code{RemoveChild(name)}}{Remove the child \code{Node} called \code{name} from a \code{Node} and returns it.}
  \item{\code{RemoveAttribute(name, stopIfNotAvailable)}}{Removes attribute called \code{name} from this \code{Node}. Gives an error if \code{stopIfNotAvailable} and the attribute doesn't exist.}
  \item{\code{\link{Climb}(...)}}{Find a node with path \code{...}, where the \code{...} arguments are the \code{name}s of the \code{Node}s, or other field values.}
  \item{\code{\link{Navigate}(path)}}{Find a node by relative \code{path}}
  \item{\code{\link{FindNode}(name)}}{Find a node with name \code{name}. Especially useful if \code{\link{AreNamesUnique}} is \code{TRUE}}
  \item{\code{\link{Get}(attribute, ..., traversal = c("pre-order", "post-order", "in-order", "level", "ancestor"), pruneFun = NULL, filterFun = NULL, format = NULL, inheritFromAncestors = FALSE, simplify = c(TRUE, FALSE, "array", "regular"))}}{Traverses the tree and collects values along the way.}
  \item{\code{\link{Do}(fun, ..., traversal = c("pre-order", "post-order", "in-order", "level", "ancestor"), pruneFun = NULL, filterFun = NUL)}}{Traverses the tree and call fun on each node.}
  \item{\code{\link{Set}(..., traversal = c("pre-order", "post-order", "in-order", "level", "ancestor"), pruneFun = NULL, filterFun = NULL)}}{Traverses the tree and assigns the args along the way, recycling the args.}
  \item{\code{\link{Sort}(attribute, ..., decreasing = FALSE, recursive = TRUE}}{Sort children of a node with respect to an attribute (field, method, active, function)}
  \item{\code{\link{Revert}(recursive = TRUE)}}{Revert the sort order of a node}
  \item{\code{\link{Prune}(pruneFun)}}{Prune a tree. The pruneFun takes a node as its first argument, and returns TRUE if the node should be kept, FALSE otherwise}

}
}

\section{Actives (aka Properties)}{

  
\describe{
 \item{\code{name}}{Gets or sets the name of a \code{Node}. For example \code{Node$name <- "Acme"}}
 \item{\code{parent}}{Gets or sets the parent \code{Node} of a \code{Node}. Only set this if you know what you are doing, as you might mess up the tree structure!}
 \item{\code{children}}{Gets or sets the children \code{list} of a \code{Node}. Only set this if you know what you are doing, as you might mess up the tree structure!}
 \item{\code{siblings}}{Returns a list of the siblings of this \code{Node}}
 \item{\code{fields}}{Gets the names of the set properties of a \code{Node}}
 \item{\code{fieldsAll}}{Gets the names of the set properties of a \code{Node} or any of its sub-Nodes}
 \item{\code{isLeaf}}{Returns \code{TRUE} if the \code{Node} is a leaf, \code{FALSE} otherwise}
 \item{\code{isRoot}}{Returns \code{TRUE} if the \code{Node} is the root, \code{FALSE} otherwise}
 \item{\code{count}}{Returns the number of children of a \code{Node}}
 \item{\code{totalCount}}{Returns the total number of \code{Node}s in the tree}
 \item{\code{path}}{Returns a vector of mode \code{character} containing the names of the \code{Node}s in the path from the root to this \code{Node}}
 \item{\code{pathString}}{Returns a string representing the path to this \code{Node}, separated by backslash}
 \item{\code{levelName}}{Returns the name of the \code{Node}, preceded by level times '*'. Useful for printing.}
 \item{\code{leafCount}}{Returns the number of leaves are below a \code{Node} }
 \item{\code{leaves}}{Returns a list containing all the leaf \code{Node}s }
 \item{\code{level}}{Returns an integer representing the level of a \code{Node}. For example, the root has level 1.}
 \item{\code{height}}{Returns max(level) of any of the \code{Nodes} of the tree}
 \item{\code{averageBranchingFactor}}{Returns the average number of crotches below this \code{Node}}
 \item{\code{root}}{Returns the root \code{Node} of a \code{Node}'s tree}
 
}
}
\examples{
library(data.tree)
acme <- Node$new("Acme Inc.")
accounting <- acme$AddChild("Accounting")$
              AddSibling("Research")$
              AddChild("New Labs")$
              parent$
              AddSibling("IT")$
              AddChild("Outsource")
print(acme)

}
\seealso{
For more details see the \code{\link{data.tree}} documentations, or the \code{data.tree} vignette: \code{vignette("data.tree")}
}
\keyword{datasets}

