% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion_rpart.R
\name{as.Node.rpart}
\alias{as.Node.rpart}
\title{Convert an \code{\link{rpart}} object to a \code{data.tree} structure}
\usage{
\method{as.Node}{rpart}(x, digits = getOption("digits") - 3,
  use.n = FALSE, ...)
}
\arguments{
\item{x}{the \code{rpart} object to be converted}

\item{digits}{the number of digits to be used for numeric values in labels}

\item{use.n}{logical. Add cases to labels, see \code{\link{text.rpart}} for further
information}

\item{...}{any other argument to be passed to generic sub implementations}
}
\value{
a \code{data.tree} object. The tree contains a field \code{rpart.id} which
        references back to the original node id in the row names of the \code{rpart} object.
}
\description{
Convert an \code{\link{rpart}} object to a \code{data.tree} structure
}
\examples{
if (require(rpart)) {
   fit <- rpart(Kyphosis ~ Age + Number + Start, data = kyphosis)
   as.Node(fit)
}
}
\seealso{
Other as.Node: \code{\link{as.Node.data.frame}},
  \code{\link{as.Node.dendrogram}},
  \code{\link{as.Node.list}}, \code{\link{as.Node.phylo}},
  \code{\link{as.Node}}
}
\concept{as.Node}
