#' @title Simplified Rmarkdown rendering
#'
#' @description Render a Rmarkdown (.Rmd) file, \code{file}, to the output
#' format specified in its preamble. If no output format is specified,
#' it will be rendered to html.
#'
#' @param file A character string path to the file that is to be rendered.
#' This file must be of type Rmarkdown (.Rmd)
#'
#' @param quiet A logical. Should messages during rendering be surpressed?
#'
#' @details This function is merely a simplified version (in terms of
#' possible arguments) of the rendering function from the \code{rmarkdown} package.
#' Therefore, we refer to this functions for more details:
#' \code{\link[rmarkdown]{render}}. We have included this simplified version in
#' \code{dataMaid} in order to help new R users with rendering their output
#' documents as generated by \code{\link{makeDataReport}}.
#'
#' @seealso \code{\link[rmarkdown]{render}}.
#'
#' @export
render <- function(file, quiet) {

    if (!rmarkdown::pandoc_available()) {
        stop("pandoc appears not to be installed on the system. Please see the vignette for the rmarkdown package on how to install pandoc")
    }

    rmarkdown::render(file, quiet=quiet)
}
