% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.R
\name{fastDiscretization}
\alias{fastDiscretization}
\title{Discretization}
\usage{
fastDiscretization(dataSet, bins = NULL, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{bins}{Result of funcion \code{\link{build_bins}}, (list, default to NULL). \cr
To perform the same discretization on train and test, it is recommended to compute \code{\link{build_bins}}
before. If it is kept to NULL, build_bins will be called.\cr
\code{bins} could also be carefully hand written.}

\item{verbose}{Should the algorithm talk? (Logical, default to TRUE)}
}
\value{
Same dataset discretized by \strong{reference}. \cr
If you don't want to edit by reference please provide set \code{dataSet = copy(dataSet)}.
}
\description{
Discretization of numeric variable (either equal_width or equal_fred).
}
\details{
NAs will be putted in an NA category.
}
\examples{
# Load data
data(messy_adult)
head(messy_adult)

# Compute bins
bins <- build_bins(messy_adult, cols = "auto", n_bins = 5, type = "equal_freq")

# Discretize
messy_adult <- fastDiscretization(messy_adult, bins = bins)

# Control
head(messy_adult)

# Example with hand written bins
data("adult")
adult <-  fastDiscretization(adult, bins = list(age = c(0, 40, +Inf)))
print(table(adult$age))
}
