% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findNLDI.R
\name{findNLDI}
\alias{findNLDI}
\title{R Client for the Network Linked Data Index}
\usage{
findNLDI(
  comid = NULL,
  nwis = NULL,
  wqp = NULL,
  huc12 = NULL,
  location = NULL,
  origin = NULL,
  nav = NULL,
  find = c("flowlines"),
  distance_km = 100,
  no_sf = FALSE,
  warn = TRUE
)
}
\arguments{
\item{comid}{numeric or character. An NHDPlusV2 COMID}

\item{nwis}{numeric or character. A USGS NWIS surface water siteID}

\item{wqp}{numeric or character. A water quality point ID}

\item{huc12}{numeric or character. A WBD HUC12 unit ID}

\item{location}{numeric vector. Coordinate pair in WGS84
SRS ordered lng/lat (X,Y)}

\item{origin}{named list. Specifying a feature type and ID
(e.g. list("comid" = 101))}

\item{nav}{character vector. where to navigate from the starting point.
Options include along the upper mainsteam (UM), upstream tributary (UT),
downstream mainstem (DM) and downstream divergences (DD). You may select
one or more of the abbreviations ("UM", "UT", DM", "DD").}

\item{find}{character vector. Define what resources to find along the
navigation path(s) (see get_nldi_sources()$source). Can also include 'basin'
or 'flowline', which will return the upstream basin of the starting feature
or flowlines along the navigation respectively. The default is "flowlines".
If you provide any other resource, AND want flowlines, then flowlines must
be explicitly requested.}

\item{distance_km}{numeric. Define how far to look along the navigation path in
kilometers (default = 100)}

\item{no_sf}{if available, should `sf` be used for parsing,
defaults to `TRUE` if `sf` is locally installed}

\item{warn}{(default TRUE) should warnings be printed}
}
\value{
a list of data.frames if sf is not installed, a list of sf objects if it is
}
\description{
Provides a formal client to the USGS
Network Linked Data Index.
}
\details{
The function is useful for topology and location based
feature discovery. A user must specify an origin feature, optional navigation
direction(s) along the network, as well as features to identify along the
navigated paths. Valid starting options can be given by one of the following
arguments: comid, nwis, huc12, wqp, location, and start.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Find Features / Define origin features

## Find feature by COMID
findNLDI(comid = 101)

## Find feature by NWIS ID
findNLDI(nwis = "11120000")

## Find feature by WQP ID
findNLDI(wqp = "USGS-04024315")

## Find feature by LOCATION
findNLDI(location = c(-115, 40))

## GENERAL ORIGIN: COMID
findNLDI(origin = list("comid" = 101))

# Navigation (flowlines will be returned if find is unspecified)
# UPPER MAINSTEM of USGS-11120000
findNLDI(nwis = "11120000", nav = "UM")

# MULTI-REQUEST
# UPPER MAINSTEM and TRIBUTARY of USGS-11120000
findNLDI(nwis = "11120000", nav = c("UT", "UM"))

# Discover Features(flowlines will not be returned unless included in find)

## Find feature(s) on the upper tributary of USGS-11120000
findNLDI(nwis = "11120000", nav = "UT", find = c("nwis", "wqp"))

## Find upstream basin boundary and  of USGS-11120000
findNLDI(nwis = "11120000", find = "basin")

# Control Distance
## Limit search to 50 km
findNLDI(comid = 101, nav = "DM", find = c("nwis", "wqp", "flowlines"), distance_km = 50)
}
\dontshow{\}) # examplesIf}
}
\keyword{nldi}
