% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_session_activity.R
\name{list_session_activity}
\alias{list_session_activity}
\title{List Activity History in Databrary Session.}
\usage{
list_session_activity(session_id = 6256, vb = FALSE, rq = NULL)
}
\arguments{
\item{session_id}{Selected session/slot number.}

\item{vb}{A Boolean value. If TRUE provides verbose output.}

\item{rq}{An \code{httr2} request object. Defaults to NULL. To access the activity
history on a volume a user has privileges on. Create a request
(\code{rq <- make_default_request()}); login using \code{make_login_client(rq = rq)};
then run \verb{list_session_activity(session_id = <YOUR_SESSION_ID>, rq = rq)}}
}
\value{
A list with the activity history on a session/slot.
}
\description{
If a user has access to a volume and session, this function returns the
history of modifications to that session.
}
\examples{
\donttest{
\dontrun{
# The following will only return output if the user has write privileges
# on the session.

list_session_activity(session_id = 6256, vb = FALSE) # Activity for session 6256.
}
}
}
