% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_volume_funding.R
\name{list_volume_funding}
\alias{list_volume_funding}
\title{Lists Funders Associated With a Databrary Volume.}
\usage{
list_volume_funding(
  vol_id = 1,
  add_id = TRUE,
  vb = options::opt("vb"),
  rq = NULL
)
}
\arguments{
\item{vol_id}{Target volume number.}

\item{add_id}{A logical value. Include the volume ID in the output. Default is TRUE.}

\item{vb}{Show verbose messages. (Defaults to \code{FALSE}, overwritable using option 'databraryr.vb' or environment variable 'R_DATABRARYR_VB')}

\item{rq}{An \code{httr2} request object.}
}
\value{
A data frame with funder information for the volume.
}
\description{
Lists Funders Associated With a Databrary Volume.
}
\examples{
\donttest{
\dontrun{
list_volume_funding() # Funding for volume 1

list_volume_funding(vol_id = c(1:10))
}
}

}
