% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datacheck.R
\name{is_datadict_profile}
\alias{is_datadict_profile}
\title{is.datadict.profile}
\usage{
is_datadict_profile(x)
}
\arguments{
\item{x}{The object to be tested.}
}
\value{
boolean
}
\description{
Is this a datadict.profile object
}
\examples{
library(stringr)
# Get example data files
atable <- system.file("examples/db.csv", package = "datacheck")
arule <- system.file("examples/rules1.R", package = "datacheck")
aloctn <- system.file("examples/location.csv", package = "datacheck")  # for use in is.oneOf

ctable <- basename(atable)
crule <- basename(arule)
cloctn <- basename(aloctn)

cwd <- tempdir()
owd <- getwd()
setwd(cwd)

file.copy(atable, ctable)
file.copy(arule, crule)
file.copy(aloctn, cloctn)

at <- read.csv(ctable, stringsAsFactors = FALSE)
ad <- read_rules(crule)

db <- datadict_profile(at, ad)

is_datadict_profile(db) == TRUE

db

setwd(owd)

}
\author{
Reinhard Simon
}
\seealso{
Other datadict: \code{\link{as.rules}};
  \code{\link{as_rules}}; \code{\link{datadict.profile}};
  \code{\link{datadict_profile}};
  \code{\link{has.ruleErrors}};
  \code{\link{has_rule_errors}};
  \code{\link{is.datadict.profile}};
  \code{\link{prep4rep}}; \code{\link{read.rules}};
  \code{\link{read_rules}}
}

