% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{data_validator}
\alias{data_validator}
\title{Convert a dataclass to a data frame validator}
\usage{
data_validator(x)
}
\arguments{
\item{x}{A dataclass object}
}
\value{
A function with the following properties:

* A modified dataclass function designed to accept data frames
* A single argument to test new data frames
* Each column in a new data frame will be tested
* An error occurs if new data passed to the returned function are invalid
* Data is returned if new data passed to the returned function are valid
}
\description{
If you intend to use your dataclass to validate data frame like object such
as tibbles, data frames, or data tables, pass the dataclass into this 
function to modify behavior.
}
\examples{
# Define a dataclass for creating data! Wrap in data_validator():
my_df_dataclass <-
 data_validator(dataclass(
   dte_col = dte_vec(),
   chr_col = chr_vec(),
   # Custom column validator ensures values are positive!
   new_col = function(x) all(x > 0)
 ))

# Validate a data frame or data frame like objects!
my_df_dataclass(data.frame(
 dte_col = as.Date("2022-01-01"),
 chr_col = "String!",
 new_col = 100
))
}
