% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{lgl_vec}
\alias{lgl_vec}
\title{Validator: Check if element is a logical}
\usage{
lgl_vec(max_len = Inf, min_len = 1, level = "error", allow_na = FALSE)
}
\arguments{
\item{max_len}{The maximum length of a logical element}

\item{min_len}{The minimum length of a logical element}

\item{level}{Setting "warn" throws a warning, setting "error" halts}

\item{allow_na}{Should NA values be allowed?}
}
\value{
A function with the following properties:
\itemize{
\item Checks whether something is a logical vector
\item Determines whether the check will throw warning or error
\item Optionally checks for element length
}
}
\description{
This function is used to check whether something is a logical. You can use
this function to check the length of a logical vector. You can also specify
the level of a violation. If level is set to "warn" then invalid inputs will
warn you. However, if level is set to "error" then invalid inputs will abort.
}
\examples{
# Define a dataclass for testing logicals:
my_dataclass <-
  dataclass(
    bool = lgl_vec()
  )

# `bool` must be a logical vector of any length!
my_dataclass(
  bool = TRUE
)
}
