% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/var_imp.R
\name{var_imp}
\alias{var_imp}
\title{Variable Importance Measure for A FSM Model}
\usage{
var_imp(state_mat, action_vec, data, outcome, period, measure)
}
\arguments{
\item{state_mat}{Numeric matrix with rows as states and columns as
predictors.}

\item{action_vec}{Numeric vector indicating what action to take for each
state.}

\item{data}{Data frame that has "period" and "outcome" columns and rest of
cols are predictors, ranging from one to three predictors. All of the (3-5
columns) should be named.}

\item{outcome}{Numeric vector same length as the number of rows as data.}

\item{period}{Numeric vector same length as the number of rows as data.}

\item{measure}{Optional length one character vector that is either:
 "accuracy", "sens", "spec", or "ppv". This specifies what measure of
 predictive performance to use for training and evaluating the model. The
 default measure is \code{"accuracy"}. However, accuracy can be a problematic
 measure when the classes are imbalanced in the samples, i.e. if a class the
 model is trying to predict is very rare. Alternatives to accuracy are
 available that illuminate different aspects of predictive power. Sensitivity
 answers the question, `` given that a result is truly an event, what is the
 probability that the model will predict an event?'' Specificity answers the
 question, ``given that a result is truly not an event, what is the
 probability that the model will predict a negative?'' Positive predictive
 value answers, ``what is the percent of predicted positives that are
 actually positive?''}
}
\value{
Numeric vector the same length as the number of columns of the
  provided state matrix (the number of predictors in the model) with relative
  importance scores for each predictor.
}
\description{
\code{var_imp} calculates the importance of the covariates of the model.
}
\details{
Takes the state matrix and action vector from an already evolved model and
the fitness function and data used to evolve the model (or this could be test
data), flips the values of each of the elements in the state matrix and
measures the change in fitness (prediction of data) relative to the original
model. Then these changes are summed across columns to provide the importance
of each of the columns of the state matrix.
}

