% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{snaspeChile}
\alias{snaspeChile}
\title{On the National System of State Protected Wild Areas (SNASPE) of Chile.}
\format{
Contains the following variables:
\describe{
\item{unit.id}{Number for the unit.}
\item{unit}{Name of the protected area.}
\item{category}{Category of the unit. It can be either a National Park, a National Reserve or a Natural Monument.}
\item{commune}{Name of the commune (the smallest Chilean territorial division) where the unit is located.}
\item{province}{Province where the comunne is located (one territorial division level above the commune).}
 \item{region}{Region where the province is located (one territorial division level above the province and the biggest Chilean territorial division).}
\item{perim.km}{Perimeter, in km.}
\item{area.ha}{Area, in hectares.}
\item{area.m2}{Area, in m\eqn{^{2}}{^2}.}
 }
}
\source{
These data is freely available at
\url{https://ide.minagri.gob.cl/geoweb/2019/11/21/medio-ambiente/}
}
\usage{
data(snaspeChile)
}
\description{
Dataset contains the protected wild areas of Chile that are part of the National System of State Protected Wild Areas (SNASPE).
}
\examples{
data(snaspeChile)    
head(snaspeChile) 
}
\references{
The SNASPE has been created and is currently managed by the National Forest Corporation (CONAF).
More information and documentation can be found at
\url{https://www.conaf.cl/parques-nacionales/parques-de-chile/}
}
\keyword{datasets}
