% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{beetles2}
\alias{beetles2}
\title{Crecimiento poblacional de escarabajos.}
\format{
\describe{
  \item{dias}{Numero de dias.}
  \item{dieta}{La cantidad de harina (en gramos) de ambientes donde crecen los escarabajos.  Seis niveles del factor Dieta.}
  \item{tipo}{Estados de desarrollo de los escarabajos, i.e., huevos, larvas, pupas, y adultos.}
  \item{densidad}{Numero total de individuos por ambiente de crecimiento.}
 }
}
\source{
Datos del Cuadro No. 1, page 116, de Chapman (1928). Serie de experimentos bajo condiciones controladas
 donde escarabajos (Tribolium confusum) se mantienen en ambientes de tamaño conocido. 
 El periodo desde huevo a adulto es de aproximadamente de cuarenta dias a 27 grados Celsius. Los datos
 fueron digitados por Yamara Arancibia, una estudiante del Prof. Christian Salas-Eljatib.
}
\usage{
beetles2
}
\description{
Mediciones temporales de densidad de escarabajos (Tribolium confusum) creciendo en 
 diferentes ambientes controlados.
}
\examples{
data(beetles2)    
nom.dieta<-unique(beetles2$dieta)
num.dieta<-length(nom.dieta)
##Grafico de serie de tiempo
#primero algunos calculos
alys<-with(beetles2,tapply(densidad, list(as.factor(dias),as.factor(dieta)),sum))
out<-as.data.frame(alys)
out$tiempo<-row.names(out)
head(out)
##Figura 1 del paper
matplot(out[,"tiempo"], out[,1:num.dieta], las=1, type=c("b"),pch=1,
        xlab="Tiempo en dias",ylab="Densidad de individuos")
legend("topleft", legend = nom.dieta, title = "Dieta (gr)",
       col = 1:6, lty = 1:6, pch = 1)
}
\references{
- Chapman RN. 1928. The Quantitative Analysis of Environmental Factors. Ecology 9(2):111-122.
}
\keyword{datasets}
