% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{deadForestCA2}
\alias{deadForestCA2}
\title{Los datos contienen variables climaticas, de estructura forestal y de mortalidad forestal.}
\format{
Variables se describen a continuacion::
\describe{
\item{live.bah}{Area basal viva del conjunto de datos GNN}											
\item{live.tph}{Arboles vivos por hectarea del conjunto de datos GNN}
\item{pos.x}{posicion x del orden de clasificacion de la celda de la cuadricula (la posicion 1 es la mas occidental)}
\item{pos.y}{posicion y del orden de clasificacion de la celda de la cuadricula (la posicion 1 es la mas al norte)}
\item{alb.x}{coordenada x del centroide de la celda de la cuadricula en California Albers (EPSG 3310)}
\item{alb.y}{coordenada y del centroide de la celda de la cuadricula en California Albers (EPSG 3310)}
\item{mort.bin}{1 = árboles muertos observados en la celda de la cuadricula. 0 = no se observaron árboles muertos}
\item{mort.tph}{Arboles muertos por hectarea del conjunto de datos ADS agregado}
\item{mort.tpa}{Arboles muertos por acre del conjunto de datos ADS agregado}
\item{year}{año del vuelo de ADS. La mayoria de los vuelos se realizaron entre mayo y agosto}
\item{Defnorm}{Deficit hidrico climatico anual medio para la celda de la cuadricula, para el año hidrico del 1 de octubre al 31 de septiembre, promediado de 1981 a 2015}
\item{Def0}{Deficit de agua climatica para la celda de la cuadricula durante el año hidrologico de octubre a septiembre que se superpone al vuelo ADS de verano del año dado}
\item{Defz0}{Puntaje Z para el deficit hidrico climatico para la celda de cuadricula / año hidrico dado. Calculado como (Def0-Defnorm) / (desviacion estandar en el deficit entre todos los años 1981-2015 para la celda de la cuadricula dada}
\item{Defz1}{Puntuacion Z para el deficit h?drico climatico para la celda de la cuadricula dada en el año hidrologico anterior.}
\item{Defz2}{Puntuacion Z para el deficit hidrico climatico para la celda de la cuadricula dada dos años antes.}
\item{Tz0}{Puntaje Z para la temperatura para la celda de cuadricula / año dado.}
\item{Pz0}{Puntaje Z para la precipitacion para la celda / año de la cuadricula dado.}
\item{Defquant}{Variable FDCI. Cuantil de Defnorm de la celda de la cuadricula dada, en relacion con la Defnorm de todas las demas celdas de la cuadricula con un area basal dentro de 2.5 m\eqn{^{2}}{^2}/ha de la celda dada}
 }
}
\source{
The data were provided from DRYAD repository.
}
\usage{
data(deadForestCA2)
}
\description{
El archivo de datos contiene una fila por combinacion unica de celda de cuadricula de 3,5 km por año. 
El marco de datos cubre todas las celdas de la cuadricula dentro del estado de California donde se 
tomo al menos un vuelo de la Encuesta de deteccion aerea (ADS) entre 2009 y 2015, por lo que cada posicion
de celda de la cuadricula tiene entre 1 y 7 años de datos (reflejados como 1 a 7 filas en el archivo de datos
por posicion de celda de cuadricula). Las principales variables de respuesta son mort.bin (presencia de alguna mortalidad)
 y mort.tph (numero de árboles muertos /ha dentro de la celda de la cuadricula por año).
}
\examples{
data(deadForestCA2)    
head(deadForestCA2) 
}
\references{
-Derek J. N. Young, Jens T. Stevens, J. Mason Earles, Jeffrey Moore, Adam Ellis, Amy L. Jirka, and Andrew M. Latimer.
 Long-term climate and competition explain forest mortality patterns under extreme drought.Ecology Letters, 20(1):78-86, 2017.

-Salas-Eljatib C, Fuentes-Ramirez A., Gregoire TG, Altamirano A., and Yaitul V. A study on the effects of unbalanced data when
 fitting logistic regression models in ecology. Ecological Indicators, 85:502-508, 2018.
}
\keyword{datasets}
