% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankmod.r
\name{rankmod}
\alias{rankmod}
\title{Function to produce a table ranks the models being analyzed.}
\usage{
rankmod(
  tabstatmod = tabstatmod,
  all.refstat = TRUE,
  refstat = refstat,
  want.all.outputs = FALSE
)
}
\arguments{
\item{tabstatmod}{a data object having the statistics values for
each model. The first column must have the name of the model, and
the other columns are the statistics.}

\item{all.refstat}{A logic option to specify the statistics to
be used for ranking the models. By default is to \code{TRUE}, implying
that all the statistics provided in the object (i.e., columns) are
going to be used for developing the ranking. If the
option \code{all.refstat} is set to \code{FALSE}, then the option \code{refstat}
must be specified.}

\item{refstat}{A vector with the names of the
columns (i.e., statistics) to be used. By the default is the name
of all the columns of the object \code{tabstatmod} but not including
the first column (it has the name of the model).}

\item{want.all.outputs}{A logic option to save a full set of
result elements in the output, thus the output is class \code{list}.
By default is set to \code{FALSE}.}
}
\value{
The main result is a table having assigned scores for
each of the statistics, as well as the sum of the scores. The
column \code{ranking} has between the best ranking (number \code{1}) to
the lowest ranking (number equal to the quantity of models
being analyzed). The actual output is a list with two elements:
(1) a dataframe sorted by the number of the model,
and (2) a dataframe sorted by the ranking of the model.
}
\description{
Prepare a table that ranks previously fitted models according
to a series of statistics
}
\details{
The function assigns scores to models based on an array of
statistics already computed. For instance, the function can use
the three prediction capabilities statistics RMSD, AD, and AAD,
that are computed by the function \code{valesta()}. Nonetheless, any
other statistics can be provided to the function. The only
requirement is that the lower the value of the
statistics (in absolute value), the better. The current version of
the function is based upon the approach proposed by Salas (2002).
}
\examples{
##Creates a fake dataframe  
set.seed(1234);y<-rnorm(30, 30,9);x<-rnorm(30, 450,133);z<-rbeta(30, .1,2)
db <- as.data.frame(cbind(y, x,z))
## Fitting some models
mod1 <- lm(y~x, data=db)
mod2 <- lm(y~x+I(x^2), data=db)
mod3 <- lm(y~z+I(x^2), data=db)
## Preparing the format of the input-data for the function
df.m1<-df.m2<-df.m3<-db
df.m1$model<-"mod1";df.m1$y.aju=fitted(mod1)
df.m2$model<-"mod2";df.m2$y.aju=fitted(mod2)
df.m3$model<-"mod3";df.m3$y.aju=fitted(mod3)
df<-rbind(df.m1,df.m2,df.m3)
head(df)
##Assign validation class
df<-assigncl(data=df,variable="y")
table(df$model)
table(df$y.class)
head(df)
##Computes prediction capabilities statistics
df.torank<-valestamod(data=df,y.obs = "y", y.pred="y.aju",
        want.by.valcl = TRUE,val.class = "y.class")
df.torank
##Example 1: getting the main output, sorted by the ranking
rankmod(tabstatmod = df.torank)
##Example 2: only consider a portion of the availables statistics
rankmod(tabstatmod = df.torank, all.refstat=FALSE,
refstat=c("rmsd","ad","aad"))
}
\references{
\itemize{
\item Salas C. 2002. Ajuste y validación de ecuaciones de volumen
para un relicto del bosque de roble-laurel-lingue.
Bosque 23(2):81–92. \doi{10.4067/S0717-92002002000200009}.
}
}
\author{
Christian Salas-Eljatib and Marcos Marivil.
}
