% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddr.R
\name{ddr}
\alias{ddr}
\alias{ddr_field_specs}
\title{Get DDR data}
\usage{
ddr(date, asset_class, field_specs = ddr_field_specs())

ddr_field_specs()
}
\arguments{
\item{date}{the date for which data is required as Date or DateTime object.
Only the year, month and day elements of the object are used and it must of
be length one.}

\item{asset_class}{the asset class for which you would like to download trade
data. Valid inputs are \code{"CR"} (credit), \code{"IR"} (rates),
\code{"EQ"} (equities), \code{"FX"} (foreign exchange), \code{"CO"}
(commodities). This must be a string.}

\item{field_specs}{a valid column specification that is passed to
\code{\link[readr:read_csv]{readr::read_csv()}} with a default value provided by \code{ddr_field_specs()}}
}
\value{
a tibble that contains the requested data. If no data exists
on that date, an empty tibble is returned.
}
\description{
The DTCC Data Repository is a registered U.S. swap data repository that
allows market participants to fulfil their public disclosure obligations
under U.S. legislation. This function will give you the ability to download
trade-level data that is reported by market participants. The field names are
(and is assumed to be) the same for each asset class.
}
\examples{
\dontrun{
library("lubridate")
ddr(ymd(20170525), "IR") # Not empty
}
}
\references{
\href{https://rtdata.dtcc.com/gtr/}{DDR Real Time Dissemination
Platform}
}
