/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.foresite.Agent;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.DateParser;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREFactory;
import org.dspace.foresite.OREParserException;
import org.dspace.foresite.ReMSerialisation;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.Triple;
import org.dspace.foresite.Vocab;
import org.dspace.foresite.jena.AgentJena;
import org.dspace.foresite.jena.AggregationJena;
import org.dspace.foresite.jena.JenaOREFactory;
import org.dspace.foresite.jena.ORE;
import org.dspace.foresite.jena.OREResourceJena;
import org.dspace.foresite.jena.OREX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMapJena
extends OREResourceJena
implements ResourceMap {
    @Override
    public void empty() {
    }

    @Override
    public void detach() throws OREException {
    }

    @Override
    public void initialise(URI uri) throws OREException {
        String ident = uri.toString();
        String rx = ".+://.+";
        Pattern p = Pattern.compile(rx);
        Matcher m = p.matcher(ident);
        if (!m.matches()) {
            throw new OREException("Illegal URI: " + uri.toString() + "; ResourceMap requires a protocol-based URI");
        }
        this.res = this.model.createResource(uri.toString());
        this.res.addProperty(RDF.type, (RDFNode)ORE.ResourceMap);
    }

    @Override
    public boolean isAuthoritative() throws OREException {
        StmtIterator itr = this.res.listProperties(OREX.isAuthoritativeFor);
        return itr.hasNext();
    }

    @Override
    public void setAuthoritative(boolean authoritative) throws OREException {
        if (authoritative) {
            SimpleSelector selector = new SimpleSelector(null, ORE.isDescribedBy, (RDFNode)this.res);
            StmtIterator itr = this.model.listStatements((Selector)selector);
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                this.res.addProperty(OREX.isAuthoritativeFor, (RDFNode)statement.getSubject());
            }
        } else {
            this.res.removeAll(OREX.isAuthoritativeFor);
        }
    }

    @Override
    public List<Agent> getCreators() {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        StmtIterator itr = this.res.listProperties(DC.creator);
        while (itr.hasNext()) {
            Statement statement = itr.nextStatement();
            Agent agent = JenaOREFactory.createAgent((Resource)statement.getObject());
            agents.add(agent);
        }
        return agents;
    }

    @Override
    public void setCreators(List<Agent> creators) {
        this.clearCreators();
        for (Agent creator : creators) {
            this.addCreator(creator);
        }
    }

    @Override
    public void addCreator(Agent creator) {
        Resource resource = ((AgentJena)creator).getResource();
        this.res.addProperty(DC.creator, (RDFNode)resource);
        this.addResourceToModel(resource);
    }

    @Override
    public void clearCreators() {
        List<Agent> creators = this.getCreators();
        for (Agent creator : creators) {
            Model cModel = ((AgentJena)creator).getModel();
            StmtIterator itr = cModel.listStatements();
            this.model.remove(itr);
        }
    }

    @Override
    public Date getCreated() throws OREException {
        try {
            StmtIterator itr = this.res.listProperties(DCTerms.created);
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                String value = ((Literal)statement.getObject()).getLexicalForm();
                Date created = DateParser.parse(value);
                return created;
            }
            return null;
        }
        catch (OREParserException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setCreated(Date created) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String date = sdf.format(created);
        this.res.addProperty(DCTerms.created, (RDFNode)this.model.createTypedLiteral(date, "http://www.w3.org/2001/XMLSchema#date"));
    }

    @Override
    public Date getModified() throws OREException {
        try {
            StmtIterator itr = this.res.listProperties(DCTerms.modified);
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                String value = ((Literal)statement.getObject()).getLexicalForm();
                Date modified = DateParser.parse(value);
                return modified;
            }
            return null;
        }
        catch (OREParserException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setModified(Date modified) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String date = sdf.format(modified);
        this.res.addProperty(DCTerms.modified, (RDFNode)this.model.createTypedLiteral(date, "http://www.w3.org/2001/XMLSchema#date"));
    }

    @Override
    public void removeModified() throws OREException {
        this.res.removeAll(DCTerms.modified);
    }

    @Override
    public String getRights() {
        Statement statement = this.res.getProperty(DC.rights);
        if (statement != null) {
            return statement.getString();
        }
        return null;
    }

    @Override
    public void setRights(String rights) {
        this.res.addProperty(DC.rights, (RDFNode)this.model.createTypedLiteral(rights));
    }

    @Override
    public void removeRights() {
        this.res.removeAll(DC.rights);
    }

    @Override
    public void setTypes(List<URI> types) {
        super.setTypes(types);
        SimpleSelector selector = new SimpleSelector(this.res, RDF.type, (RDFNode)ORE.ResourceMap);
        StmtIterator itr = this.model.listStatements((Selector)selector);
        if (!itr.hasNext()) {
            this.res.addProperty(RDF.type, (RDFNode)ORE.ResourceMap);
        }
    }

    @Override
    public void clearTypes() {
        super.clearTypes();
        this.res.addProperty(RDF.type, (RDFNode)ORE.ResourceMap);
    }

    @Override
    public Vocab getOREType() throws OREException {
        return Vocab.ore_ResourceMap;
    }

    @Override
    public Aggregation createAggregation(URI uri) throws OREException {
        Aggregation agg = OREFactory.createAggregation(uri);
        this.setAggregation(agg);
        ((AggregationJena)agg).setModel(this.model, uri);
        return agg;
    }

    @Override
    public Aggregation getAggregation() throws OREException {
        try {
            StmtIterator itr = this.res.listProperties(ORE.describes);
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                String resURI = ((Resource)statement.getObject()).getURI();
                Aggregation aggregation = JenaOREFactory.createAggregation(this.model, new URI(resURI));
                return aggregation;
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void setAggregation(Aggregation aggregation) throws OREException {
        try {
            ReMSerialisation serialisation = new ReMSerialisation();
            serialisation.setURI(new URI(this.res.getURI()));
            StmtIterator itr = this.res.listProperties(DC.format);
            String mime = "application/octet-stream";
            if (itr.hasNext()) {
                Statement statement = itr.nextStatement();
                mime = ((Literal)statement.getObject()).getLexicalForm();
            }
            serialisation.setMimeType(mime);
            aggregation.addReMSerialisation(serialisation);
            Model aModel = ((AggregationJena)aggregation).getModel();
            this.addModelToModel(aModel);
        }
        catch (URISyntaxException e) {
            throw new OREException(e);
        }
    }

    @Override
    public void removeAggregation() throws OREException {
        AggregationJena agg = (AggregationJena)this.getAggregation();
    }

    @Override
    public List<AggregatedResource> getAggregatedResources() throws OREException {
        Aggregation agg = this.getAggregation();
        return agg.getAggregatedResources();
    }

    @Override
    public List<Triple> doSparql(String sparql) {
        return null;
    }

    @Override
    public ResourceMap copy() throws OREException {
        Model model = this.getModel();
        StmtIterator itr = model.listStatements();
        Model nModel = ModelFactory.createDefaultModel();
        nModel.add(itr);
        ResourceMap nrem = JenaOREFactory.createResourceMap(nModel, this.getURI());
        return nrem;
    }

    @Override
    public void setModel(Model model, URI resourceURI) throws OREException {
        Resource subject = model.createResource(resourceURI.toString());
        SimpleSelector aggSelector = new SimpleSelector(subject, ORE.aggregates, (RDFNode)null);
        SimpleSelector proxySelector = new SimpleSelector(subject, ORE.proxyFor, (RDFNode)null);
        StmtIterator aggItr = model.listStatements((Selector)aggSelector);
        StmtIterator proxyItr = model.listStatements((Selector)proxySelector);
        if (aggItr.hasNext() || proxyItr.hasNext()) {
            throw new OREException("ResourceMap may not have the same URI as an Aggregation or Proxy");
        }
        super.setModel(model, resourceURI);
    }
}

