/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.sparql.util.Utils;

public class OpAssign
extends Op1 {
    private VarExprList assignments;

    public static Op assign(Op op, Var var, Expr expr) {
        if (!(op instanceof OpAssign)) {
            VarExprList x = new VarExprList();
            x.add(var, expr);
            return new OpAssign(op, x);
        }
        OpAssign opAssign = (OpAssign)op;
        opAssign.assignments.add(var, expr);
        return opAssign;
    }

    public OpAssign(Op subOp) {
        super(subOp);
        this.assignments = new VarExprList();
    }

    public OpAssign(Op subOp, VarExprList exprs) {
        super(subOp);
        this.assignments = exprs;
    }

    public String getName() {
        return "assign";
    }

    public void add(Var var, Expr expr) {
        this.assignments.add(var, expr);
    }

    public VarExprList getVarExprList() {
        return this.assignments;
    }

    public int hashCode() {
        return this.assignments.hashCode() ^ this.getSubOp().hashCode();
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op subOp) {
        OpAssign op = new OpAssign(subOp, new VarExprList(this.getVarExprList()));
        return op;
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpAssign)) {
            return false;
        }
        OpAssign assign2 = (OpAssign)other;
        if (!Utils.eq(this.assignments, assign2.assignments)) {
            return false;
        }
        return this.getSubOp().equalTo(assign2.getSubOp(), labelMap);
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }
}

