/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.probability.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Histogram;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.IndexModelAccess;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.Pattern;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.impl.Selectivity;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProbabilityIndex {
    private int level = 1;
    private long indexedSize = 0L;
    private long indexedNumRes = 0L;
    private long ssSize = -1L;
    private long soSize = -1L;
    private long osSize = -1L;
    private long ooSize = -1L;
    private Selectivity selectivity = null;
    private Model indexModel = null;
    private IndexModelAccess ga = new IndexModelAccess();
    private Map properties = new HashMap();
    private Map histograms = new HashMap();
    private Map patterns = new HashMap();
    private Set exclude = new HashSet();
    private static Log log = LogFactory.getLog((Class)ProbabilityIndex.class);

    public void load(Model indexModel) {
        this.indexModel = indexModel;
        this.ga.load(indexModel);
        this.indexedSize = this.ga.getSize();
        this.level = this.ga.getLevel();
        this.indexedNumRes = this.ga.getResources();
        this.properties = this.ga.getProperties();
        this.histograms = this.ga.getHistograms();
        this.patterns = this.ga.getPatterns();
        this.ssSize = this.ga.getSSSize();
        this.soSize = this.ga.getSOSize();
        this.osSize = this.ga.getOSSize();
        this.ooSize = this.ga.getOOSize();
        this.exclude = this.ga.getExProperty();
    }

    public void create(Model dataModel, Config config) {
        if (config != null) {
            this.level = config.getIndexLevel();
            this.exclude = config.getExProperty();
        }
        this.selectivity = new Selectivity(dataModel);
        this.createTripleIndex(dataModel);
        if (this.level > 0) {
            this.createTriplesIndex(dataModel);
        }
        this.indexModel = this.ga.create(this);
    }

    public Model getModel() {
        return this.indexModel;
    }

    public long lookup(Property property) {
        long num = 0L;
        if (this.properties.containsKey(property)) {
            num = (Long)this.properties.get(property);
        } else {
            log.debug((Object)("Index not found (return " + num + "): " + property.toString()));
        }
        return num;
    }

    public boolean allowsJoinedProbability() {
        return this.level > 0;
    }

    public int getLevel() {
        return this.level;
    }

    public long getIndexedNumRes() {
        return this.indexedNumRes;
    }

    public long getIndexedSize() {
        return this.indexedSize;
    }

    public Map getHistograms() {
        return this.histograms;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Map getPatterns() {
        return this.patterns;
    }

    public long getIndexedSSSize() {
        return this.ssSize;
    }

    public long getIndexedSOSize() {
        return this.soSize;
    }

    public long getIndexedOSSize() {
        return this.osSize;
    }

    public long getIndexedOOSize() {
        return this.ooSize;
    }

    public Set getExProperty() {
        return this.exclude;
    }

    private void createTripleIndex(Model dataModel) {
        Property property;
        long frequency;
        HashMap objects = new HashMap();
        ResIterator resIter = dataModel.listSubjects();
        while (resIter.hasNext()) {
            resIter.next();
            ++this.indexedNumRes;
        }
        log.debug((Object)("Number of resources: " + this.indexedNumRes));
        StmtIterator stmtIter = dataModel.listStatements();
        while (stmtIter.hasNext()) {
            Statement stmt = stmtIter.nextStatement();
            Property predicate = stmt.getPredicate();
            if (!this.exclude(predicate)) {
                frequency = 0L;
                Node object = stmt.getObject().asNode();
                List<Object> objectsL = new ArrayList<Node>();
                if (this.properties.containsKey(predicate)) {
                    frequency = (Long)this.properties.get(predicate);
                }
                if (objects.containsKey(predicate)) {
                    objectsL = (List)objects.get(predicate);
                }
                objectsL.add(object);
                this.properties.put(predicate, new Long(++frequency));
                objects.put(predicate, objectsL);
            }
            ++this.indexedSize;
        }
        log.debug((Object)("Model size: " + this.indexedSize));
        log.debug((Object)("Number of properties: " + this.properties.size()));
        Iterator iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            property = (Property)iter.next();
            frequency = (Long)this.properties.get(property);
            log.debug((Object)("Indexed property and frequency: " + frequency + " " + property.toString()));
        }
        iter = objects.keySet().iterator();
        while (iter.hasNext()) {
            property = (Property)iter.next();
            List objectsL = (List)objects.get(property);
            Histogram histogram = new Histogram();
            histogram.addElements(objectsL);
            log.debug((Object)("Create histogram for property: " + property));
            log.debug((Object)("Number of histogram objects: " + objectsL.size()));
            this.histograms.put(property, histogram);
        }
    }

    private void createTriplesIndex(Model dataModel) {
        this.ssSize = this.selectivity(new Triple(Node.createVariable((String)"s1"), Node.createVariable((String)"p1"), Node.createVariable((String)"o1")), new Triple(Node.createVariable((String)"s1"), Node.createVariable((String)"p2"), Node.createVariable((String)"o2")));
        this.soSize = this.selectivity(new Triple(Node.createVariable((String)"s1"), Node.createVariable((String)"p1"), Node.createVariable((String)"o1")), new Triple(Node.createVariable((String)"s2"), Node.createVariable((String)"p2"), Node.createVariable((String)"s1")));
        this.osSize = this.selectivity(new Triple(Node.createVariable((String)"s1"), Node.createVariable((String)"p1"), Node.createVariable((String)"o1")), new Triple(Node.createVariable((String)"o1"), Node.createVariable((String)"p2"), Node.createVariable((String)"o2")));
        this.ooSize = this.selectivity(new Triple(Node.createVariable((String)"s1"), Node.createVariable((String)"p1"), Node.createVariable((String)"o1")), new Triple(Node.createVariable((String)"s2"), Node.createVariable((String)"p2"), Node.createVariable((String)"o1")));
        Iterator iter = this.properties.keySet().iterator();
        while (iter.hasNext()) {
            Property property1 = (Property)iter.next();
            if (this.exclude(property1)) continue;
            Iterator it = this.properties.keySet().iterator();
            while (it.hasNext()) {
                Property property2 = (Property)it.next();
                if (this.exclude(property2)) continue;
                this.index(new Pattern(property1, property2, ResourceFactory.createResource((String)"http://jena.hpl.hp.com/ARQo/join#SS")));
                this.index(new Pattern(property1, property2, ResourceFactory.createResource((String)"http://jena.hpl.hp.com/ARQo/join#SO")));
                this.index(new Pattern(property1, property2, ResourceFactory.createResource((String)"http://jena.hpl.hp.com/ARQo/join#OS")));
                this.index(new Pattern(property1, property2, ResourceFactory.createResource((String)"http://jena.hpl.hp.com/ARQo/join#OO")));
            }
        }
    }

    private long selectivity(Triple triple1, Triple triple2) {
        long frequency = this.selectivity.calculate(triple1, triple2);
        log.debug((Object)("Indexed: " + frequency + " [" + triple1 + ", " + triple2 + "]"));
        return frequency;
    }

    private void index(Pattern pattern) {
        long frequency = this.selectivity.calculate(pattern);
        this.patterns.put(pattern, new Long(frequency));
        log.debug((Object)("Indexed pattern and frequency: " + frequency + " " + pattern.toString()));
    }

    private boolean exclude(Property property) {
        if (this.exclude == null) {
            return false;
        }
        return this.exclude.contains(property);
    }
}

